//
//  AABB.h
//  SBGame
//
//  Created by Stuart Bryson on 24/09/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SBVector3D, SBMat4;

@interface AABB : NSObject {
	SBVector3D * min, * max;
}

+ (id)AABBWithMin:(SBVector3D *)_min max:(SBVector3D *)_max;

- (id)initWithAABB:(AABB *)rhs;
- (id)initWithMin:(SBVector3D *)_min max:(SBVector3D *)_max;

- (void)setMin:(SBVector3D *)_min;
- (void)setMax:(SBVector3D *)_max;
- (void)setWithMin:(SBVector3D *)_min max:(SBVector3D *)_max;

- (void)includePoint:(SBVector3D *)p;
- (void)includeAABB:(AABB *)rhs;
- (void)transform:(SBMat4 *)m;
- (void)translate:(SBVector3D *)t;
- (void)setEmpty;

- (void)assign:(AABB *)rhs;

- (SBVector3D *)min;
- (SBVector3D *)max;
- (SBVector3D *)center;
- (SBVector3D *)extents;


- (BOOL)isEmpty;
- (BOOL)intersects:(AABB *)rhs;
- (BOOL)containsAABB:(AABB *)_aabb;
- (BOOL)containsVector3D:(SBVector3D *)vec;

- (void)logValues;

@end
