//
//  AABB.m
//  SBGame
//
//  Created by Stuart Bryson on 24/09/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "AABB.h"
#import "SBMat4.h"
#import "SBVector3D.h"
#import "SBVector4D.h"
#import "SBStream.h"

@implementation AABB

+ (id)AABBWithMin:(SBVector3D *)_min max:(SBVector3D *)_max
{ return [[AABB alloc] initWithMin:_min max:_max]; }

- (id) copyWithZone:(NSZone *)zone
{
    return [[[AABB allocWithZone:zone] initWithAABB:self] autorelease];
}

- (id)init
{
	if ( self = [super init] )
	{
		// init with 'empty' values
		min = [[SBVector3D maxVector] retain];
		max = [[SBVector3D minVector] retain];
		return self;
	}
	return nil;
}

- (id)initWithAABB:(AABB *)rhs
{
	if ( self = [super init] )
	{
		min = [[[rhs min] copy] retain];
		max = [[[rhs max] copy] retain];
		return self;
	}
	return nil;
}

- (id)initWithMin:(SBVector3D *)_min max:(SBVector3D *)_max
{
	if ( self = [super init] )
	{
		min = [[_min copy] retain];
		max = [[_max copy] retain];
		return self;
	}
	return nil;
}

- (void)dealloc
{
	[min release];
	[max release];
	[super dealloc];
}

- (void)setMin:(SBVector3D *)_min
{
	[min assign:_min];
}

- (void)setMax:(SBVector3D *)_max
{
	[max assign:_max];
}

- (void)setWithMin:(SBVector3D *)_min max:(SBVector3D *)_max
{
	[min assign:_min];
	[max assign:_max];
}

- (void)setWithVertexStream:(SBVertexStream *)stream
{
	//NSAssert( 0, @"Not implemented yet" );
	
	// ensure stream is a position stream with stride 3
	//NSAssert([stream streamType] == SI_Position, @"AABB setWithVertexStream: stream is not a position stream" );
	//NSAssert([stream stride] == 3, @"AABB setWithVertexStream: stream stride is not 3" );
	
	// iterate through stream setting min and max as we go
	
	
}

- (void)setEmpty
{
	[min setMax];
	[max setMin];
}

- (float) minA:(float)a b:(float)b
{
	return a <= b ? a : b;
}

- (float) maxA:(float)a b:(float)b
{
	return a >= b ? a : b;
}

- (void)transform:(SBMat4 *)m
{
	SBVector3D * oldMin = [[min copy] retain];
	SBVector3D * oldMax = [[max copy] retain];

	if ( [oldMin isMax] || [oldMax isMin] )
	{
		return;
	}
	
	[self setEmpty];
	
	SBVector4D * vec;
	// update the AABB with the 8 transformed points on the AABB
	vec = [m multiplyByVector4D:[SBVector4D vector4DWithValuesX:[oldMin x] y:[oldMin y] z:[oldMin z] w:1.f]];
	[self includePoint:(SBVector3D *)vec];
	vec = [m multiplyByVector4D:[SBVector4D vector4DWithValuesX:[oldMax x] y:[oldMin y] z:[oldMin z] w:1.f]];
	[self includePoint:(SBVector3D *)vec];
	vec = [m multiplyByVector4D:[SBVector4D vector4DWithValuesX:[oldMax x] y:[oldMax y] z:[oldMin z] w:1.f]];
	[self includePoint:(SBVector3D *)vec];
	vec = [m multiplyByVector4D:[SBVector4D vector4DWithValuesX:[oldMin x] y:[oldMax y] z:[oldMin z] w:1.f]];
	[self includePoint:(SBVector3D *)vec];
	vec = [m multiplyByVector4D:[SBVector4D vector4DWithValuesX:[oldMax x] y:[oldMax y] z:[oldMax z] w:1.f]];
	[self includePoint:(SBVector3D *)vec];
	vec = [m multiplyByVector4D:[SBVector4D vector4DWithValuesX:[oldMin x] y:[oldMax y] z:[oldMax z] w:1.f]];
	[self includePoint:(SBVector3D *)vec];
	vec = [m multiplyByVector4D:[SBVector4D vector4DWithValuesX:[oldMin x] y:[oldMin y] z:[oldMax z] w:1.f]];
	[self includePoint:(SBVector3D *)vec];
	vec = [m multiplyByVector4D:[SBVector4D vector4DWithValuesX:[oldMax x] y:[oldMin y] z:[oldMax z] w:1.f]];
	[self includePoint:(SBVector3D *)vec];

	[oldMin release];
	[oldMax release];
}

- (void)translate:(SBVector3D *)t
{
	[min assign:[min addVector:t]];
	[max assign:[max addVector:t]];
}

- (void)includeAABB:(AABB *)rhs
{
	// set the extents to be the min and max of rhs
	SBVector3D * rhsMin = [rhs min];
	
	[min setX: [self minA:[min x] b:[rhsMin x]]];
	[min setY: [self minA:[min y] b:[rhsMin y]]];
	[min setZ: [self minA:[min z] b:[rhsMin z]]];
	
	SBVector3D * rhsMax = [rhs max];
	
	[max setX: [self maxA:[max x] b:[rhsMax x]]];
	[max setY: [self maxA:[max y] b:[rhsMax y]]];
	[max setZ: [self maxA:[max z] b:[rhsMax z]]];
}

- (void)includePoint:(SBVector3D *)p
{
	[min setX: [self minA:[min x] b:[p x]]];
	[min setY: [self minA:[min y] b:[p y]]];
	[min setZ: [self minA:[min z] b:[p z]]];
	
	[max setX: [self maxA:[max x] b:[p x]]];
	[max setY: [self maxA:[max y] b:[p y]]];
	[max setZ: [self maxA:[max z] b:[p z]]];
}

- (void)assign:(AABB *)rhs
{
	[self setWithMin:[rhs min] max:[rhs max]];
}

- (SBVector3D *)min { return min; }
- (SBVector3D *)max { return max; }
- (SBVector3D *)center { return [[min addVector:max] divideByFloat:2]; }
- (SBVector3D *)extents { return [[min subtractVector:max] divideByFloat:2]; }

- (BOOL)isEmpty
{
	return ([min isMax] && [max isMin]);
}

- (BOOL)intersects:(AABB *)rhs
{
	if ( [max x] < [[rhs min] x] || [min x] > [[rhs max] x] ||
		 [max y] < [[rhs min] y] || [min y] > [[rhs max] y] ||
		 [max z] < [[rhs min] z] || [min z] > [[rhs max] z] )
	{
		return NO;
	}
	return YES;
}

- (BOOL)containsAABB:(AABB *)_aabb
{
	if ( [self containsVector3D:[_aabb min]] && [self containsVector3D:[_aabb max]] )
	{
		return YES;
	}
	return NO;
}

- (BOOL)containsVector3D:(SBVector3D *)vec
{
	return ([vec x] >= [min x] && [vec x] <= [max x] &&
			[vec y] >= [min y] && [vec y] <= [max y] &&
			[vec z] >= [min z] && [vec z] <= [max z] );
}

- (void)logValues
{
	[min logValues];
	[max logValues];
}

@end
