//
//  Controller.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <OpenGL/OpenGL.h>
#import <OpenGL/gl.h>
#import <OpenGL/glu.h>

@class SBGLView, SBNonuniformSpline, SBScene;

@interface Controller : NSObject
{
	// outlets to connect to the SBGLView and the main window
	IBOutlet SBGLView * glView;
	IBOutlet NSWindow * mainWindow;
	
	// outlets to connect the preferences controls
	IBOutlet NSWindow * preferenceSheet;
	IBOutlet NSTextField * renderIntervalField;
	IBOutlet NSTextField * mazeSizeField;
	IBOutlet NSTextField * octreeDepthField;
	
	// outlet to update the toggle render timer menu item
	IBOutlet NSMenuItem * toggleRenderTimerMenuItem;
	IBOutlet NSMenuItem * wireframeMenuItem;
	IBOutlet NSMenuItem * drawInfoMenuItem;
	IBOutlet NSMenuItem * demoModeMenuItem;
	IBOutlet NSMenuItem * drawWorldAABBsMenuItem;
	IBOutlet NSMenuItem * drawLocalAABBsMenuItem;
	IBOutlet NSMenuItem * drawOctreeMenuItem;
	IBOutlet NSMenuItem * drawUsingOctreeMenuItem;
	IBOutlet NSMenuItem * testInFrustumMenuItem;
	IBOutlet NSMenuItem * drawPathPointsMenuItem;
	
	// lua console outlets
	IBOutlet NSMenuItem * luaConsoleMenuItem;
	IBOutlet NSTextView * luaConsoleInputText;
	
	// member variables for storing timer stuff
	NSTimer * renderTimer;
	NSTimer * demoTimer;
	NSTimeInterval renderTimeInterval;
	
	BOOL demo;
	float currentDemoFrame;
	
	// camera spline
	SBNonuniformSpline * cameraSpline;
}

+ (SBScene *)scene;

- (void) initialiseDefaults;
- (void) initialiseMenuItems;
- (void) awakeFromNib; // this is called by NSApp as this class is its delegate
- (void) initFailed;

- (void) resetRenderTimer;
- (void) startRenderTimer;
- (void) startDemoTimer;
- (void) viewNextFrame: (NSTimer *)timer;
- (void) updateGLView: (NSTimer *)timer;

// IBActions are triggered by something from our GUI
- (IBAction) toggleFullScreen: (id)sender;
- (IBAction) toggleWireframe: (id)sender;
- (IBAction) toggleDrawInfo: (id)sender;
- (IBAction) toggleDrawWorldAABBs: (id)sender;
- (IBAction) toggleDrawLocalAABBs: (id)sender;
- (IBAction) toggleDrawOctree: (id)sender;
- (IBAction) toggleDrawUsingOctree: (id)sender;
- (IBAction) toggleTestInFrustum: (id)sender;
- (IBAction) toggleDrawPathPoints: (id)sender;

- (IBAction) refreshView: (id)sender;
- (IBAction) resetCamera: (id)sender;
- (IBAction) toggleRenderTimer: (id)sender;
- (IBAction) openCameraSpline: (id)sender;
- (IBAction) toggleDemo: (id)sender;

- (IBAction) editPreferences: (id)sender;
- (IBAction) closePreferenceSheet: (id)sender;
- (IBAction) savePreferences: (id)sender;

- (IBAction) openScene: (id)sender;
- (IBAction) generateMaze: (id)sender;
- (void) loadMasterEntities;
+ (NSDictionary *) lookupGLTexture:(NSString *)imagePath;
+ (GLuint) loadGLTexture:(NSString *)imagePath;

- (IBAction) executeLua: (id)sender;

@end