/*
Copyright (C) 2004 - 2005 Alias Systems Corp. and/or its licensors.

Permission is hereby granted, free of charge, to any person obtaining a copy

of this software and associated documentation files (the "Software"), to 
deal in the Software without restriction, including without limitation the 
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or 
sell copies of the Software, and to permit persons to whom the Software is 
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in 
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN 
THE SOFTWARE.
*/

#ifndef __COLLADA_SYNTAX_INCLUDED__
#define __COLLADA_SYNTAX_INCLUDED__

#define XML_STR (const xmlChar*) 

#define COLLADA_VERSION						"1.3.0"
#define COLLADA_SCHEMA						"http://www.collada.org/2005/COLLADASchema"

#define COLLADA_DOCUMENT_STRUCTURE			"COLLADA"
#define COLLADA_ASSET_STRUCTURE				"asset"
#define COLLADA_REVISION_STRUCTURE			"revision"
#define COLLADA_AUTHORING_TOOL_STRUCTURE	"authoring_tool"
#define COLLADA_MODIFIED_STRUCTURE			"modified"
#define COLLADA_AUTHOR_STRUCTURE			"author"
#define COLLADA_UNIT_STRUCTURE				"unit"
#define COLLADA_SOURCE_DATA_STRUCTURE		"source_data"
#define COLLADA_UP_AXIS_STRUCTURE			"up_axis"
#define COLLADA_LIBRARY_STRUCTURE			"library"
#define COLLADA_SCENE_STRUCTURE				"scene"
#define COLLADA_NODE_STRUCTURE				"node"
#define COLLADA_INSTANCE_STRUCTURE			"instance"
#define COLLADA_MATRIX_STRUCTURE			"matrix"
#define COLLADA_TRANSLATE_STRUCTURE			"translate"
#define COLLADA_ROTATE_STRUCTURE			"rotate"
#define COLLADA_SCALE_STRUCTURE				"scale"
#define COLLADA_SKEW_STRUCTURE				"skew"
#define COLLADA_LOOKAT_STRUCTURE			"lookat"
#define COLLADA_GEOMETRY_STRUCTURE			"geometry"
#define COLLADA_MESH_STRUCTURE				"mesh"
#define COLLADA_VERTICES_STRUCTURE			"vertices"
#define COLLADA_POLYGONS_STRUCTURE			"polygons"
#define COLLADA_TRIANGLES_STRUCTURE			"triangles"
#define COLLADA_POLYGON_STRUCTURE			"p"
#define COLLADA_ANIMATION_STRUCTURE			"animation"
#define COLLADA_CONTROLLER_STRUCTURE		"controller"
#define COLLADA_SKIN_STRUCTURE				"skin"
#define COLLADA_COMBINER_STRUCTURE			"combiner"
#define COLLADA_JOINTS_STRUCTURE			"joints"
#define COLLADA_VALUE_STRUCTURE				"v"
#define COLLADA_MATERIAL_STRUCTURE			"material"
#define COLLADA_SHADER_STRUCTURE			"shader"
#define COLLADA_PASS_STRUCTURE				"pass"
#define COLLADA_PROGRAM_STRUCTURE			"program"
#define COLLADA_TEXTURE_STRUCTURE			"texture"
#define COLLADA_IMAGE_STRUCTURE				"image"
#define COLLADA_INPUT_STRUCTURE				"input"
#define COLLADA_TECHNIQUE_STRUCTURE			"technique"
#define COLLADA_SOURCE_STRUCTURE			"source"
#define COLLADA_ACCESSOR_STRUCTURE			"accessor"
#define COLLADA_EXTRA_STRUCTURE				"extra"
#define COLLADA_BOUNDINGBOX_STRUCTURE		"boundingbox"
#define COLLADA_MIN_STRUCTURE				"min"
#define COLLADA_MAX_STRUCTURE				"max"
#define COLLADA_PERSPECTIVE_STRUCTURE		"perspective"

#define COLLADA_ARRAY_STRUCTURE				"array"
#define COLLADA_FLOAT_ARRAY_STRUCTURE		"float_array"
#define COLLADA_INT_ARRAY_STRUCTURE			"int_array"
#define COLLADA_NAME_ARRAY_STRUCTURE		"Name_array"
#define COLLADA_BOOL_ARRAY_STRUCTURE		"bool_array"

#define COLLADA_SAMPLER_STRUCTURE			"sampler"
#define COLLADA_CHANNEL_STRUCTURE			"channel"
#define COLLADA_CAMERA_STRUCTURE			"camera"
#define COLLADA_OPTICS_STRUCTURE			"optics"
#define COLLADA_PROGRAM_STRUCTURE			"program"
#define COLLADA_PARAMETER_STRUCTURE			"param"

#define COLLADA_TYPE_PROPERTY				"type"
#define COLLADA_ID_PROPERTY					"id"
#define COLLADA_SUBID_PROPERTY				"sid"
#define COLLADA_NAME_PROPERTY				"name"
#define COLLADA_COUNT_PROPERTY				"count"
#define COLLADA_STRIDE_PROPERTY				"stride"
#define COLLADA_URL_PROPERTY				"url"
#define COLLADA_SEMANTIC_PROPERTY			"semantic"
#define COLLADA_SOURCE_PROPERTY				"source"
#define COLLADA_TARGET_PROPERTY				"target"
#define COLLADA_PROFILE_PROPERTY			"profile"
#define COLLADA_MATERIAL_PROPERTY			"material"
#define COLLADA_ALT_MATERIAL_PROPERTY		"alt_material"
#define COLLADA_METER_PROPERTY				"meter"
#define COLLADA_IDX_PROPERTY				"idx"
#define COLLADA_FLOW_PROPERTY				"flow"

#define COLLADA_GEOMETRY_LIBRARY_TYPE		"GEOMETRY"
#define COLLADA_CONTROLLER_LIBRARY_TYPE		"CONTROLLER"
#define COLLADA_ANIMATION_LIBRARY_TYPE		"ANIMATION"
#define COLLADA_MATERIAL_LIBRARY_TYPE		"MATERIAL"
#define COLLADA_TEXTURE_LIBRARY_TYPE		"TEXTURE"
#define COLLADA_IMAGE_LIBRARY_TYPE			"IMAGE"
#define COLLADA_LIGHT_LIBRARY_TYPE			"LIGHT"
#define COLLADA_CAMERA_LIBRARY_TYPE			"CAMERA"

#define COLLADA_LAMBERT_SHADER_TYPE			"LAMBERT"
#define COLLADA_PHONG_SHADER_TYPE			"PHONG"
#define COLLADA_CONSTANT_SHADER_TYPE		"CONSTANT"

#define COLLADA_NAME_TYPE					"name"
#define COLLADA_FLOAT_TYPE					"float"
#define COLLADA_BOOL_TYPE					"bool"
#define COLLADA_INT_TYPE					"int"
#define COLLADA_FLOAT3_TYPE					"float3"
#define COLLADA_FLOAT4_TYPE					"float4"
#define COLLADA_FUNCTION_TYPE				"function"
#define COLLADA_MATRIX_TYPE					"float4x4"

#define COLLADA_JOINT_NODE_TYPE				"JOINT"
#define COLLADA_NODE_NODE_TYPE				"NODE"

#define COLLADA_TEXTURE_SEMANTIC			"TEXTURE"
#define COLLADA_IMAGE_SEMANTIC				"IMAGE"
#define COLLADA_INPUT_SEMANTIC				"INPUT"
#define COLLADA_OUTPUT_SEMANTIC				"OUTPUT"
#define COLLADA_IN_TANGENT_SEMANTIC			"IN_TANGENT"
#define COLLADA_OUT_TANGENT_SEMANTIC		"OUT_TANGENT"
#define COLLADA_INTERPOLATION_SEMANTIC		"INTERPOLATION"
#define COLLADA_JOINT_SEMANTIC				"JOINT"
#define COLLADA_BIND_POSITION_SEMANTIC		"BIND_SHAPE_POSITION"
#define COLLADA_BIND_NORMAL_SEMANTIC		"BIND_SHAPE_NORMAL"
#define COLLADA_JOINT_AND_WEIGHT_SEMANTIC	"JOINTS_AND_WEIGHTS"
#define COLLADA_BIND_MATRIX_SEMANTIC		"INV_BIND_MATRIX"
#define COLLADA_JOINT_PARAMETER				"JOINT"
#define COLLADA_WEIGHT_PARAMETER			"WEIGHT"

#define COLLADA_GENERIC_TECHNIQUE			"COMMON"
#define COLLADA_TIME_TARGET					"TIME"

#define COLLADA_VERTEX_INPUT				"VERTEX"
#define COLLADA_POSITION_INPUT				"POSITION"
#define COLLADA_NORMAL_INPUT				"NORMAL"
#define COLLADA_COLOR_INPUT					"COLOR"
#define COLLADA_MAPPING_INPUT				"UV"
#define COLLADA_ALT_MAPPING_INPUT			"TEXCOORD"
#define COLLADA_TEXCOORD_INPUT				"TEXCOORD"
#define COLLADA_TANGENT_INPUT				"TANGENT"
#define COLLADA_BINORMAL_INPUT				"BINORMAL"

#define COLLADA_AMBIENT_ATTRIBUTE			"AMBIENT"
#define COLLADA_DIFFUSE_ATTRIBUTE			"DIFFUSE"
#define COLLADA_SPECULAR_ATTRIBUTE			"SPECULAR"
#define COLLADA_BUMP_ATTRIBUTE				"BUMP"
#define COLLADA_GLOW_ATTRIBUTE				"GLOW"
#define COLLADA_TRANSPARENCY_ATTRIBUTE		"TRANSPARENCY"
#define COLLADA_EMISSION_ATTRIBUTE			"EMISSION"
#define COLLADA_TRANSPARENT_ATTRIBUTE		"TRANSPARENT"
#define COLLADA_REFLECTIVE_ATTRIBUTE		"REFLECTIVE"
#define COLLADA_REFLECTIVITY_ATTRIBUTE		"REFLECTIVITY"
#define COLLADA_SHININESS_ATTRIBUTE			"SHININESS"

#define COLLADA_AMBIENT_LIGHT_TYPE			"AMBIENT"
#define COLLADA_DIRECTIONAL_LIGHT_TYPE		"DIRECTIONAL"
#define COLLADA_SPOT_LIGHT_TYPE				"SPOT"
#define COLLADA_POINT_LIGHT_TYPE			"POINT"
#define COLLADA_ORTHOGRAPHIC_CAM_TYPE		"ORTHOGRAPHIC"
#define COLLADA_PERSPECTIVE_CAM_TYPE		"PERSPECTIVE"

#define COLLADA_LIGHT_COLOR_PARAMETER					"COLOR"
#define COLLADA_LIGHT_ATTENUATION_PARAMETER				"ATTENUATION"
#define COLLADA_LIGHT_ATTENUATION_SCALE_PARAMETER		"ATTENUATION_SCALE"
#define COLLADA_LIGHT_FALLOFF_PARAMETER					"FALLOFF"
#define COLLADA_LIGHT_FALLOFF_SCALE_PARAMETER			"FALLOFF_SCALE"
#define COLLADA_LIGHT_ANGLE_PARAMETER					"ANGLE"

#define COLLADA_TEXTURE_WRAPU_PARAMETER					"wrapU"
#define COLLADA_TEXTURE_WRAPV_PARAMETER					"wrapV"
#define COLLADA_TEXTURE_MIRRORU_PARAMETER				"mirrorU"
#define COLLADA_TEXTURE_MIRRORV_PARAMETER				"mirrorV"

#define COLLADA_CONSTANT_FUNCTION			"CONSTANT"
#define COLLADA_LINEAR_FUNCTION				"LINEAR"
#define COLLADA_QUADRATIC_FUNCTION			"QUADRATIC"

#define COLLADA_X_UP						"X_UP"
#define COLLADA_Y_UP						"Y_UP"
#define COLLADA_Z_UP						"Z_UP"

#define COLLADA_IN_FLOW						"IN"
#define COLLADA_OUT_FLOW					"OUT"
#define COLLADA_INOUT_FLOW					"INOUT"

// Obsolete, but kept here for backward compatibility.
#define COLLADA_RGB_TYPE					"ColorRGB"  // use float3 instead
#define COLLADA_RGBA_TYPE					"ColorRGBA" // use float4 instead
#define COLLADA_RGB_INPUT					"COLORRGB"	// beta MAX exporter has been known to generate them
#define COLLADA_RGBA_INPUT					"COLORRGBA"	// beta MAX exporter has been known to generate them

// Physics extension. Currently in prototype phase.
#define COLLADA_PHYSICS_LIBRARY_TYPE		"PHYSICS"
#define COLLADA_SHAPE_STRUCTURE				"shape"
#define	COLLADA_RIGID_BODY_STRUCTURE		"rigid_body"
#define COLLADA_DYNAMIC_STRUCTURE			"dynamic"
#define COLLADA_MASS_STRUCTURE				"mass"
#define COLLADA_PHYSICS_MATERIAL_STRUCTURE	"physics_material"
#define COLLADA_STATIC_FRICTION_ATTRIBUTE	"STATIC_FRICTION"
#define COLLADA_DYNAMIC_FRICTION_ATTRIBUTE	"DYNAMIC_FRICTION"
#define COLLADA_ELASTICITY_ATTRIBUTE		"ELASTICITY"
#define COLLADA_BOX_STRUCTURE				"box"
#define COLLADA_SPHERE_STRUCTURE			"sphere"
#define COLLADA_CAPSULE_STRUCTURE			"capsule"
#define COLLADA_CYLINDER_STRUCTURE			"cylinder"
#define COLLADA_ELLIPSOID_STRUCTURE			"ellipsoid"
#define COLLADA_SIZE_STRUCTURE				"size"
#define COLLADA_RADIUS_STRUCTURE			"radius"
#define COLLADA_PHYSICS_ENVIRONMENT_STRUCTURE	"physics_environment"
#define COLLADA_TIMESTEP_ATTRIBUTE			"TIMESTEP"
#define COLLADA_GRAVITY_ATTRIBUTE			"GRAVITY"
#define COLLADA_INITIAL_VELOCITY_STRUCTURE	"INITIAL_LINEAR_VELOCITY"
#define COLLADA_INITIAL_ANGULAR_VELOCITY_STRUCTURE	"INITIAL_ANGULAR_VELOCITY"
#define COLLADA_CONVEX_MESH_STRUCTURE		"convex_mesh"
#define COLLADA_INERTIA_STRUCTURE			"inertia"
#define COLLADA_DENSITY_STRUCTURE			"density"
#define COLLADA_CENTER_OF_MASS_STRUCTURE	"center_of_mass"
#define COLLADA_DYNAMICS_STRUCTURE			"dynamics"
#define COLLADA_RIGID_CONSTRAINT_STRUCTURE	"rigid_constraint"
#define COLLADA_BODY_PROPERTY				"body"
#define COLLADA_ATTACHMENT_STRUCTURE		"attachment"
#define COLLADA_ROT_LIMIT_MIN_STRUCTURE		"rot_limit_min"
#define COLLADA_ROT_LIMIT_MAX_STRUCTURE		"rot_limit_max"
#define COLLADA_TRANS_LIMIT_MIN_STRUCTURE	"trans_limit_min"
#define COLLADA_TRANS_LIMIT_MAX_STRUCTURE	"trans_limit_max"
#define COLLADA_ENABLED_STRUCTURE			"enabled"
#define COLLADA_INTERPENETRATE_STRUCTURE	"interpenetrate"
#define COLLADA_SPRING_STRUCTURE			"spring"
#define COLLADA_STIFFNESS_STRUCTURE			"stiffness"
#define COLLADA_DAMPING_STRUCTURE			"damping"
#define COLLADA_REST_LENGTH_STRUCTURE		"rest_length"
#define COLLADA_P0_STRUCTURE				"p0"
#define COLLADA_P1_STRUCTURE				"p1"
#define COLLADA_TRUE_KEYWORD				"TRUE"
#define COLLADA_FALSE_KEYWORD				"FALSE"
#define COLLADA_X_SEMANTIC					"X"			// e.g. isotropic friction
#define COLLADA_XY_SEMANTIC					"XY"		// e.g. anisotropic friction



//
// MAYA Profile Syntax Definitions
//

#define DAEMAYA_MAYA_TECHNIQUE					"MAYA"

#define DAEMAYA_DOUBLE_SIDED_PARAMETER			"DOUBLE_SIDED"
#define DAEMAYA_STARTTIME_PARAMETER				"START_TIME"
#define DAEMAYA_ENDTIME_PARAMETER				"END_TIME"
#define DAEMAYA_VAPERTURE_PARAMETER				"VERTICAL_APERTURE"
#define DAEMAYA_HAPERTURE_PARAMETER				"HORIZONTAL_APERTURE"
#define DAEMAYA_LENSSQUEEZE_PARAMETER			"LENS_SQUEEZE"
#define DAEMAYA_GEOMETRY_PARAMETER				"GEOMETRY"
#define DAEMAYA_WEIGHT_PARAMETER				"WEIGHT"
#define DAEMAYA_BLENDMODE_PARAMETER				"BLEND_MODE"
#define DAEMAYA_PREINFINITY_PARAMETER			"PRE_INFINITY"
#define DAEMAYA_POSTINFINITY_PARAMETER			"POST_INFINITY"
#define DAEMAYA_VISIBILITY_PARAMETER			"VISIBILITY"
#define DAEMAYA_BLINDTYPEID_PARAMETER			"BLINDTYPEID"
#define DAEMAYA_BLINDNAME_PARAMETER				"BLINDNAME"

#define DAEMAYA_TEXTURE_BLENDMODE_PARAMETER		"BLEND_MODE"
#define DAEMAYA_TEXTURE_COVERAGEU_PARAMETER		"coverageU"
#define DAEMAYA_TEXTURE_COVERAGEV_PARAMETER		"coverageV"
#define DAEMAYA_TEXTURE_TRANSFRAMEU_PARAMETER	"translateFrameU"
#define DAEMAYA_TEXTURE_TRANSFRAMEV_PARAMETER	"translateFrameV"
#define DAEMAYA_TEXTURE_ROTFRAME_PARAMETER		"rotateFrame"
#define DAEMAYA_TEXTURE_STAGGER_PARAMETER		"stagger"
#define DAEMAYA_TEXTURE_REPEATU_PARAMETER		"repeatU"
#define DAEMAYA_TEXTURE_REPEATV_PARAMETER		"repeatV"
#define DAEMAYA_TEXTURE_OFFSETU_PARAMETER		"offsetU"
#define DAEMAYA_TEXTURE_OFFSETV_PARAMETER		"offsetV"
#define DAEMAYA_TEXTURE_ROTATEUV_PARAMETER		"rotateUV"
#define DAEMAYA_TEXTURE_NOISEU_PARAMETER		"noiseU"
#define DAEMAYA_TEXTURE_NOISEV_PARAMETER		"noiseV"
#define DAEMAYA_TEXTURE_FAST_PARAMETER			"fast"

#define DAEMAYA_GEOMETRY_SEMANTIC				"GEOMETRY"
#define DAEMAYA_WEIGHT_SEMANTIC					"WEIGHT"
#define DAEMAYA_IN_TANGENT_WEIGHT_SEMANTIC		"IN_TANGENT_WEIGHT"
#define DAEMAYA_OUT_TANGENT_WEIGHT_SEMANTIC		"OUT_TANGENT_WEIGHT"
#define DAEMAYA_DRIVER_SEMANTIC					"DRIVER"
#define DAEMAYA_EXTRA_SEMANTIC					"EXTRA"

#define DAEMAYA_BLENDMODE_TYPE					"blend"
#define DAEMAYA_LAYER_TYPE						"layer"
#define DAEMAYA_INFINITY_TYPE					"infinity"
#define DAEMAYA_PROJECTION_TYPE					"projection"
#define DAEMAYA_BLIND_TYPE						"blind"
#define DAEMAYA_LONGNAME_TYPE					"long_name"
#define DAEMAYA_SHORTNAME_TYPE					"short_name"

#define DAEMAYA_PROJECTION_PROGRAM				"PROJECTION"
#define DAEMAYA_PROJECTION_TYPE_PARAMETER		"TYPE"
#define DAEMAYA_PROJECTION_MATRIX_PARAMETER		"MATRIX"

#endif 
