//
//  SBCamera.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <OpenGL/OpenGL.h>
#import <OpenGL/gl.h>
#import <OpenGL/glu.h>

@class SBCamera, SBVector3D, AABB, SBOctreeNode;

@interface SBCamera : NSObject
{
	BOOL active; // when the camera is inactive, none of the navigation commands function
	
	SBVector3D * viewPos; // View position
	SBVector3D * viewDir; // View direction vector
	SBVector3D * viewUp; // View up direction
	SBVector3D * rotPoint; // Point to rotate about
	AABB * localAABB, * worldAABB; // camera or first person bounding box
	GLdouble aperture; // pContextInfo->camera aperture
	GLint viewWidth, viewHeight; // current window/screen height and width
	
	GLfloat worldRotation[4];
	
	// bezier stuff for use in demo mode
	NSMutableArray * positionControlPoints;
	int totalFrames;
	
	SBOctreeNode * rootOctNode;
}


- (void) setActive:(BOOL)_active;
- (void) resetCamera;

// setters
- (void) setHeight:(GLint)newViewHeight;
- (void) setWidth:(GLint)newViewWidth;
- (void) setViewPos:(SBVector3D *)newViewPos collidingWithOctree:(BOOL)collide;
- (void) setViewDir:(SBVector3D *)newViewDir;
- (void) setViewUp:(SBVector3D *)newViewUp;
- (void) setAperture:(GLdouble)newAperture;
- (void) calculateWorldAABB;

// getters
- (SBVector3D *) viewPos;
- (SBVector3D *) viewDir;
- (SBVector3D *) viewUp;
- (SBVector3D *) rotPoint;
- (GLdouble) aperture;
- (GLint) viewHeight;
- (GLint) viewWidth;
- (GLfloat *)worldRotation;
- (AABB *) worldAABB;
- (AABB *) localAABB;

// navigation
- (void) move:(int)dir;
- (void) elevate:(int)dir;
- (void) strafe:(int)dir;
- (void) turn:(int)dir;
- (void) turnWithRotation:(float)angle;

@end
