//
//  SBCell.h
//  SBGame
//
//  Created by Stuart Bryson on 21/09/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface SBCell : NSObject {
	
	// cell position in grid
	int x, y;
	
	// indicates whether this wall exists
	BOOL left, right, up, down;
	
	// indicates this wall's scene entity has been created
	BOOL leftDone, rightDone, upDone, downDone;
}

+ (id) cellWithX:(int)_x y:(int)_y;

- (id) initWithX:(int)_x y:(int)_y;
- (BOOL) wallsIntact;

- (void)setLeft:(BOOL)_left;
- (void)setRight:(BOOL)_right;
- (void)setUp:(BOOL)_up;
- (void)setDown:(BOOL)_down;

- (void)setLeftDone:(BOOL)_leftDone;
- (void)setRightDone:(BOOL)_rightDone;
- (void)setUpDone:(BOOL)_upDone;
- (void)setDownDone:(BOOL)_downDone;

- (int)x;
- (int)y;

- (BOOL)left;
- (BOOL)right;
- (BOOL)up;
- (BOOL)down;

- (BOOL)leftDone;
- (BOOL)rightDone;
- (BOOL)upDone;
- (BOOL)downDone;

@end
