//
//  SBCell.m
//  SBGame
//
//  Created by Stuart Bryson on 21/09/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "SBCell.h"


@implementation SBCell

+ (id) cellWithX:(int)_x y:(int)_y
{ return [[[self alloc] initWithX:_x y:_y] autorelease]; }

- (id) initWithX:(int)_x y:(int)_y
{
	if ( self = [super init] )
	{
		x = _x;
		y = _y;
		left = right = up = down = YES; // yes means there is a wall
		leftDone = rightDone = upDone = downDone = NO;
		return self;
	}
	
	return nil;
}

- (BOOL) wallsIntact
{
	return ( left && right && up && down );
}

- (void)setLeft:(BOOL)_left { left = _left; }
- (void)setRight:(BOOL)_right { right = _right; }
- (void)setUp:(BOOL)_up { up = _up; }
- (void)setDown:(BOOL)_down { down = _down; }

- (void)setLeftDone:(BOOL)_leftDone { leftDone = _leftDone; }
- (void)setRightDone:(BOOL)_rightDone { rightDone = _rightDone; }
- (void)setUpDone:(BOOL)_upDone { upDone = _upDone; }
- (void)setDownDone:(BOOL)_downDone { downDone = _downDone; }


- (int)x { return x; }
- (int)y { return y; }

- (BOOL)left { return left; }
- (BOOL)right { return right; }
- (BOOL)up { return up; }
- (BOOL)down { return down; }

- (BOOL)leftDone { return leftDone; }
- (BOOL)rightDone { return rightDone; }
- (BOOL)upDone { return upDone; }
- (BOOL)downDone { return downDone; }

@end
