//
//  SBColladaLoader.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SBScene, SBSceneEntity;

@interface SBColladaLoader : NSObject {
	NSMutableDictionary * globalStreamsCache;
	SBScene * scene; // the scene we are loading everything into
	
	SBSceneEntity * rootEntity; // the root object of the last scene loaded
}

- (SBSceneEntity *) loadObjectWithPath:(NSString *)_scenePath;
- (BOOL)loadSceneWithPath:(NSString *)scenePath intoScene:(SBScene *)scene;
- (SBSceneEntity *)rootEntity;

@end
