//
//  SBDrawable.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <OpenGL/OpenGL.h>
#import <OpenGL/gl.h>
#import <OpenGL/glu.h>

#import "SBStream.h"

static const unsigned int SBNumberOfStreams = 8;

@interface SBDrawable : NSObject {

	// store the number of verts in our streams
	//  - all vertex streams ( vertex, normal, uv etc ) must be the same length
	unsigned int numVertices;
	// store our array of streams
	SBVertexStream * streams[ 8 ];
	
	// store our index stream
	//  - index stream may differ in length from our vertex stream
	SBIndexStream * indexStream;
	
	GLuint textureIdx, alternateTextureIdx;
	//BOOL useAlternateTextureIdx;
}

- (void) setIndexStream: (SBIndexStream *) newIndexStream;
- (void) setNumVertices: (unsigned int)newNumVertices;
- (void) addStream: (SBVertexStream *) stream;
- (void) removeStream: (SBStreamId) streamId;
- (void) setTextureIdx: (GLuint) newTextureIdx;
- (void) setAlternateTextureIdx: (GLuint) newAlternateTextureIdx;
//- (void) setUseAlternateTextureIdx: (BOOL) newUseAltTexIdx;

// getters
- (unsigned int)numVertices;
- (SBVertexStream *)streamWithType:(SBStreamId)streamType;
- (SBVertexStream *)streams;
- (unsigned int)numIndices;
- (SBIndexStream *)indexStream;
//- (GLuint)activeTextureIdx;
- (GLuint)textureIdx;
- (GLuint)alternateTextureIdx;
//- (BOOL) useAlternateTextureIdx;

@end