//
//  SBDrawable.m
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import "SBDrawable.h"

@implementation SBDrawable

- (id) init
{
	if ( self = [super init] )
	{
		indexStream = nil;
		textureIdx = -1;
		alternateTextureIdx = -1;
		//useAlternateTextureIdx = NO;
		return self;
	}
	return nil; // something went wrong with our super init
}

/*- (id) initWithDrawable:(SBDrawable *)rhs
{
	if ( self = [super init] )
	{
		indexStream = [[rhs indexStream] retain];
		
		unsigned int i;
		for ( i = 0; i < SBNumberOfStreams; i++ )
		{
			SBVertexStream * currStream = [rhs streamWithType:i];
			if ( currStream )
			{
				[self addStream:currStream];
			}
		}
		
		numVertices = [rhs numVertices];
		textureIdx = [rhs textureIdx];
		alternateTextureIdx = [rhs alternateTextureIdx];
		useAlternateTextureIdx = [rhs useAlternateTextureIdx];
		
		return self;
	}
	return nil;
}


- (id)copyWithZone:(NSZone *)zone
{
	return [[[[self class] allocWithZone: zone] initWithDrawable:self] autorelease];
}*/

- (void) setIndexStream: (SBIndexStream *) newIndexStream
{
	//NSAssert( newIndexStream != nil, @"setIndexStream:: Invalid Stream" );
	
	indexStream = [newIndexStream retain];
}

// add a stream, replacing any stream that is currently in its position
- (void) addStream: (SBVertexStream *) newStream
{
	//NSAssert( newStream != nil, @"addStream:: Invalid Stream");
		
	// get the current stream using the given streams stream type
	SBVertexStream * currStream = streams[[newStream streamType]];
	
	if ( currStream != newStream )
	{
		if ( currStream )
		{
			[self removeStream:[newStream streamType]];
		}
		
		streams[[newStream streamType]] = [newStream retain];
	}
}

- (void) setNumVertices: (unsigned int)newNumVertices
{
	numVertices = newNumVertices;
}

// remove the stream of a particular stream type
- (void) removeStream: (SBStreamId) streamType
{
	SBVertexStream * currStream = streams[streamType];
	if ( currStream != nil )
	{
		[currStream release];
	}
}

- (void) setTextureIdx: (GLuint) newTextureIdx
{
	textureIdx = newTextureIdx;
}

- (void) setAlternateTextureIdx: (GLuint) newAlternateTextureIdx
{
	alternateTextureIdx = newAlternateTextureIdx;
}

/*- (void) setUseAlternateTextureIdx: (BOOL) newUseAltTexIdx
{
	
	if ( alternateTextureIdx > 0 )
	{
		useAlternateTextureIdx = newUseAltTexIdx;
	}
}*/

// getters
- (unsigned int)numVertices { return numVertices; }
- (SBVertexStream *)streamWithType: (SBStreamId)streamType { return streams[streamType]; }
- (SBVertexStream *)streams { return streams[0]; }
- (unsigned int)numIndices { return [indexStream numElements]; }
- (SBIndexStream *)indexStream { return indexStream; }
//- (GLuint)activeTextureIdx { return useAlternateTextureIdx ? alternateTextureIdx : textureIdx; }
- (GLuint)textureIdx { return textureIdx; }
- (GLuint)alternateTextureIdx { return alternateTextureIdx; }
//- (BOOL) useAlternateTextureIdx { return useAlternateTextureIdx; }

@end