//
//  SBEnemy.h
//  SBGame
//
//  Created by Stuart Bryson on 20/10/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "SBSceneEntity.h"

typedef enum
{
	ES_ATTACKING = 0,	// pursuing player and kill him
	ES_RETREATING,		// retreating from player and eatable
	ES_BOUNCING,		// bouncing up and down on the spot but still dangerous
	ES_ELEVATED,		// elevated in the air
	ES_EATING,			// dangerous but eats the pellets for the player
	
	ES_LAST				// not used
} EnemyState;

@interface SBEnemy : SBSceneEntity
{
	EnemyState state;
	
	float targetProximity;
	float speed;
	
	NSTimer * stateTimer;
	NSTimeInterval retreatTimeInterval;
	
	BOOL bouncingUp;
}

- (id)initWithSceneEntity:(SBSceneEntity *)_sceneEntity;
- (id) initWithEnemy:(SBEnemy *)rhs;

- (EnemyState)state;
- (float)targetProximity;
- (float)speed;
- (float)retreatTimeInterval;

- (void)setState:(EnemyState)_state;
- (void) restartStateTimer;
- (void) startStateTimer;
- (void)returnToAttack:(NSTimer *)timer;

@end
