//
//  SBEnemy.m
//  SBGame
//
//  Created by Stuart Bryson on 20/10/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "SBEnemy.h"
#import "SBVector3D.h"
#import "SBMat4.h"
#import "Controller.h"
#import "SBScene.h"
#import "SBCamera.h"
#import "SBPathPoints.h"

@implementation SBEnemy

- (id) init
{
	if ( self = [super init] )
	{
		state = ES_ATTACKING;
		targetProximity = 0.1;
		speed = 0.07;
		retreatTimeInterval = 10;
		stateTimer = nil;
		bouncingUp = YES;
		
		return self;
	}
	return nil;
}

- (id) initWithSceneEntity:(SBSceneEntity *)rhs
{
	if ( self = [super initWithSceneEntity:rhs] )
	{
		state = ES_ATTACKING;
		targetProximity = 0.01;
		speed = 0.07;
		retreatTimeInterval = 10;
		stateTimer = nil;
		bouncingUp = YES;
		
		return self;
	}
	return nil;
}

- (id) initWithEnemy:(SBEnemy *)rhs
{
	// enemies are always a deep copy
	if ( self = [super initWithSceneEntity:(SBSceneEntity *)rhs] )
	{
		state = [rhs state];
		targetProximity = [rhs targetProximity];
		speed = [rhs speed];
		retreatTimeInterval = [rhs retreatTimeInterval];
		stateTimer = nil; // init with retreat timer not implemented
		bouncingUp = YES;
		
		return self;
	}
	return nil;
}

- (id)copyWithZone:(NSZone *)zone
{
	return [[[SBEnemy allocWithZone: zone] initWithEnemy:self] autorelease];
}

/*
- (id)deepCopy
{
	return [[[[self class] allocWithZone: nil ] initWithEnemy:self] autorelease];
}*/

- (void) dealloc
{
	if ( stateTimer )
	{
		[stateTimer invalidate];
		stateTimer = nil;
	}
	
	[super dealloc];
}

- (EnemyState)state { return state; }
- (float)targetProximity { return targetProximity; }
- (float)speed { return speed; }
- (float)retreatTimeInterval { return retreatTimeInterval; }

- (void) updateWithTime:(float)time
{
	SBScene * scene = [Controller scene];
	SBPathPoints * points = [scene pathPoints];
	
	// find the path to the player
	SBVector3D * enemyLoc = [localM translation];
	SBVector3D * playerLoc = [[scene camera] viewPos];
	
	NSArray * path;
	SBVector3D * target;
	
	if ( state == ES_ATTACKING || state == ES_EATING ) // eating state still tracks the player
	{
		if ( state == ES_EATING && stateTimer == nil )
		{
			[self startStateTimer];
		}
		
		path = [points findPathFromVector:enemyLoc toVector:playerLoc];
		
		if ( [path count] > 1 )
		{
			target = [[path objectAtIndex:1] translation];
		}
		else
		{
			target = enemyLoc;
		}
		
		speed = 0.07;
	}
	else if ( state == ES_RETREATING )
	{
		if ( stateTimer == nil )
		{
			[self startStateTimer];
		}
		
		SBPathPoint * farthestPoint = [points findFarthestFrom:playerLoc];
		SBPathPoint * enemyPoint = [points findClosestTo:enemyLoc];
		path = [points findPathFromPathPoint:enemyPoint toPathPoint:farthestPoint];
		
		if ( [path count] > 1 )
		{
			target = [[path objectAtIndex:1] translation];
		}
		else
		{
			target = [[path objectAtIndex:0] translation];
		}
		
		speed = 0.04;
	}
	else if ( state == ES_ELEVATED )
	{
		if ( stateTimer == nil )
		{
			[self startStateTimer];
		}
		
		target = [SBVector3D vector3DWithValuesX:[enemyLoc x] y:1 z:[enemyLoc z]];
	}
	else if ( state == ES_BOUNCING )
	{
		if ( stateTimer == nil )
		{
			[self startStateTimer];
		}
		
		if ( [enemyLoc y] > 0.9 )
		{
			bouncingUp = NO;
		}
		else if ( [enemyLoc y] < 0.1 )
		{
			bouncingUp = YES;
		}
			
		target = [SBVector3D vector3DWithValuesX:[enemyLoc x]
											   y:bouncingUp ? 1 : 0
											   z:[enemyLoc z]];
	}
	else
	{		
		return; // shouldn't ever get here
	}
	
	SBVector3D * direction = [target subtractVector:enemyLoc];
	float dist = [direction length];
	
	if ( dist > targetProximity )
	{
		[direction normalise];
		[direction assign:[direction multiplyByFloat:speed]];
		[localM setTranslation:[enemyLoc addVector:direction]];
		[self updateWorldTransform];
	}
	
	[super updateWithTime:time];
}

- (void) setState:(EnemyState)_state
{
	state = _state;
	
	[self setUseAlternateTexture:( state == ES_RETREATING )];

	if ( state != ES_ATTACKING )
	{
		[self restartStateTimer];
	}
}

- (void) restartStateTimer
{
	if ( stateTimer )
	{
		[stateTimer invalidate];
	}
	
	[self startStateTimer];
}

- (void) startStateTimer
{
	stateTimer = [[NSTimer scheduledTimerWithTimeInterval:retreatTimeInterval
												   target:self
												 selector:@selector( returnToAttack: )
												 userInfo:nil repeats:YES] retain];
}

- (void) returnToAttack:(NSTimer *)timer
{
	if ( stateTimer )
	{
		[stateTimer invalidate];
		stateTimer = nil;
	}

	[self setState:ES_ATTACKING];
}

@end
