//
//  SBGLView.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <OpenGL/OpenGL.h>
#import <OpenGL/gl.h>
#import <OpenGL/glu.h>

@class SBSceneEntity, StringTexture, SBCamera, AABB, SBOctreeNode;

@interface SBGLView : NSOpenGLView
{
	// full screen currently does not work
	//  - I don't think I am sharing the contexts correctly
	NSOpenGLContext * fullScreenGLContext;
	
	// view states
	BOOL fullScreen, wireframe, drawInfo, drawLocalAABBs, drawWorldAABBs,
		drawOctree, drawUsingOctree, testInFrustum, drawPathPoints;
	int drawOctreeDepth;
	GLfloat shapeSize;
	int numDrawnObjects;
	
	// scene and camera
	SBCamera * camera;
	
	// debug path
	NSArray * path;
	
	// input handling
	NSMutableSet * keysPressed;
	NSPoint prevMouseLoc;
	
	// string attributes
	NSMutableDictionary * stanStringAttrib, * gameStringAttrib;
	
	// string textures
	StringTexture * infoStringTex, * camStringTex, * msgStringTex, * statsStringTex;
	StringTexture * scoreStringTex, * livesStringTex;
	
	// times for message postings
	CFAbsoluteTime msgPresistance;
	CFAbsoluteTime msgTime; // message posting time for expiration
	
	NSMutableArray * frustumPlanes;
}

- (void) toggleFullScreen;
- (BOOL) wireframe;
- (void) setWireframe:(BOOL)newWireframe;
- (BOOL) drawInfo;
- (void) setDrawInfo:(BOOL)newDrawInfo;
- (BOOL) drawLocalAABBs;
- (void) setDrawLocalAABBs:(BOOL)newDrawLocalAABBs;
- (BOOL) drawWorldAABBs;
- (void) setDrawWorldAABBs:(BOOL)newDrawWorldAABBs;
- (BOOL) drawOctree;
- (void) setDrawOctree:(BOOL)newDrawOctree;
- (int) drawOctreeDepth;
- (void) setDrawOctreeDepth:(int)newDrawOctreeDepth;
- (BOOL) drawUsingOctree;
- (void) setDrawUsingOctree:(BOOL)newDrawUsingOctree;
- (BOOL) testInFrustum;
- (void) setTestInFrustum:(BOOL)newTestInFrustum;
- (BOOL) drawPathPoints;
- (void) setDrawPathPoints:(BOOL)newDrawPathPoints;

- (SBCamera *) camera;
- (void) setPath:(NSArray *)_path;

- (void) processKeys;

- (void) drawAABB:(AABB *)aabb withColorR:(float)r g:(float)g b:(float)b;
- (void) drawWorldAABBs:(SBSceneEntity *)entity;
- (void) drawAllPathPoints;
- (void) drawPath:(NSArray *)path;
- (void) drawOctreeContents:(SBOctreeNode *)octNode frustumTest:(BOOL)nodeNeedsFrustumTest;
- (void) drawEntity:(SBSceneEntity *)entity inLocalSpace:(BOOL)localSpace;
//- (void) drawRemainingLives;
//- (void) drawTexture:(NSDictionary *)texEntry withBounds:(NSRect)bounds;
//- (void) drawTexture:(NSString *)texturePath atPoint:(NSPoint)point;

- (int) aabbInFrustum:(AABB *)aabb;
- (void) calculateFrustum;
- (void) updateProjection;
- (void) updateModelView;

- (void) createMessageString;
- (void) handleMessageNotification:(NSNotification *)notification;
- (void) postMessageString: (NSString *) newMessage;
- (void) updateInfoString;
- (void) updateCameraString;
- (void) updateStatsString;
- (void) updateScoreString;
- (void) updateLivesString;
- (void) drawInfoInView;

@end
