//
//  SBMat4.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SBVector3D, SBVector4D;

@interface SBMat4 : NSObject
{
	SBVector4D * cols[4];
}

+ (id) mat4WithVec4Col0:(SBVector4D *)col0 col1:(SBVector4D *)col1 col2:(SBVector4D *)col2 col3:(SBVector4D *)col3;
+ (id) mat4WithVec3Col0:(SBVector3D *)col0 col1:(SBVector3D *)col1 col2:(SBVector3D *)col2 col3:(SBVector3D *)col3;
+ (id) mat4WithTranslation:(SBVector3D *)_trans;

- (id) init;
- (id) initWithIdentity;
- (id) initWithFloats:(float *)data;
- (id) initWithVec4Col0:(SBVector4D *)col0 col1:(SBVector4D *)col1 col2:(SBVector4D *)col2 col3:(SBVector4D *)col3;
- (id) initWithVec3Col0:(SBVector3D *)col0 col1:(SBVector3D *)col1 col2:(SBVector3D *)col2 col3:(SBVector3D *)col3;
- (id) initWithMat4:(SBMat4 *)newMat4;
- (id) initWithTranslation:(SBVector3D *)_trans;
- (id) initWithRotationY:(float)y;

- (SBMat4 *)multiplyByMat4:(SBMat4 *)rhs;
- (SBVector4D *)multiplyByVector4D:(SBVector4D *)rhs;

- (void) assign:(SBMat4 *)rhs;
- (void) setIdentity;
- (void) transpose;
- (void) inverse;

- (void) setTranslation:(SBVector3D *)_trans;
- (SBVector3D *) translation;

- (SBVector4D *)col0;
- (SBVector4D *)col1;
- (SBVector4D *)col2;
- (SBVector4D *)col3;

- (SBVector4D *)row0;
- (SBVector4D *)row1;
- (SBVector4D *)row2;
- (SBVector4D *)row3;

- (void)putContiguousDataInto:(float *)dest;

// Debugging
- (void)logValues;
- (void)logValuesAsRows;

@end
