//
//  SBMat4.m
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import "SBMat4.h"
#import "SBVector3D.h"
#import "SBVector4D.h"

@implementation SBMat4

+ (id) mat4WithVec4Col0:(SBVector4D *)col0 col1:(SBVector4D *)col1 col2:(SBVector4D *)col2 col3:(SBVector4D *)col3
{
	return [[[self alloc] initWithVec4Col0:col0 col1:col1 col2:col2 col3:col3] autorelease];
}
+ (id) mat4WithVec3Col0:(SBVector3D *)col0 col1:(SBVector3D *)col1 col2:(SBVector3D *)col2 col3:(SBVector3D *)col3
{
	return [[[self alloc] initWithVec3Col0:col0 col1:col1 col2:col2 col3:col3] autorelease];
}
+ (id) mat4WithTranslation:(SBVector3D *)_trans
{
	return [[[self alloc] initWithTranslation:_trans] autorelease];
}

- (id) init
{
	if ( self = [super init] )
	{
		cols[0] = [[SBVector4D alloc] init];
		cols[1] = [[SBVector4D alloc] init];
		cols[2] = [[SBVector4D alloc] init];
		cols[3] = [[SBVector4D alloc] init];
		return self;
	}
	return nil;
}

- (id) initWithIdentity
{
	if ( self = [super init] )
	{
		cols[0] = [[SBVector4D alloc] initWithValuesX:1 y:0 z:0 w:0];
		cols[1] = [[SBVector4D alloc] initWithValuesX:0 y:1 z:0 w:0];
		cols[2] = [[SBVector4D alloc] initWithValuesX:0 y:0 z:1 w:0];
		cols[3] = [[SBVector4D alloc] initWithValuesX:0 y:0 z:0 w:1];
		return self;
	}
	return nil;
}

- (id) initWithFloats:(float *)data
{
	if ( self = [super init] )
	{
		cols[0] = [[SBVector4D alloc] initWithValuesX:*data++ y:*data++ z:*data++ w:*data++];
		cols[1] = [[SBVector4D alloc] initWithValuesX:*data++ y:*data++ z:*data++ w:*data++];
		cols[2] = [[SBVector4D alloc] initWithValuesX:*data++ y:*data++ z:*data++ w:*data++];
		cols[3] = [[SBVector4D alloc] initWithValuesX:*data++ y:*data++ z:*data++ w:*data];
		return self;
	}
	return nil;
}

- (id) initWithVec4Col0:(SBVector4D *)newCol0 col1:(SBVector4D *)newCol1 col2:(SBVector4D *)newCol2 col3:(SBVector4D *)newCol3
{
	if ( self = [super init] )
	{		
		cols[0] = [[newCol0 copy] retain];
		cols[1] = [[newCol1 copy] retain];
		cols[2] = [[newCol2 copy] retain];
		cols[3] = [[newCol3 copy] retain];
		return self;
	}
	return nil;
}

- (id) initWithVec3Col0:(SBVector3D *)newCol0 col1:(SBVector3D *)newCol1 col2:(SBVector3D *)newCol2 col3:(SBVector3D *)newCol3
{
	if ( self = [super init] )
	{		
		cols[0] = [[SBVector4D vector4DWithValuesX:[newCol0 x] y:[newCol0 y] z:[newCol0 z] w:0.f] retain];
		cols[1] = [[SBVector4D vector4DWithValuesX:[newCol1 x] y:[newCol1 y] z:[newCol1 z] w:0.f] retain];
		cols[2] = [[SBVector4D vector4DWithValuesX:[newCol2 x] y:[newCol2 y] z:[newCol2 z] w:0.f] retain];
		cols[3] = [[SBVector4D vector4DWithValuesX:[newCol3 x] y:[newCol3 y] z:[newCol3 z] w:0.f] retain];
		
		return self;
	}
	return nil;
}

- (id) initWithMat4:(SBMat4 *)newMat4
{
	if ( self = [super init] )
	{
		cols[0] = [[[newMat4 col0] copy] retain];
		cols[1] = [[[newMat4 col1] copy] retain];
		cols[2] = [[[newMat4 col2] copy] retain];
		cols[3] = [[[newMat4 col3] copy] retain];
		return self;
	}
	return nil;
}

- (id) initWithTranslation:(SBVector3D *)_trans
{
	if ( self = [super init] )
	{
		cols[0] = [[SBVector4D alloc] initWithValuesX:1 y:0 z:0 w:0];
		cols[1] = [[SBVector4D alloc] initWithValuesX:0 y:1 z:0 w:0];
		cols[2] = [[SBVector4D alloc] initWithValuesX:0 y:0 z:1 w:0];
		cols[3] = [[SBVector4D alloc] initWithValuesX:[_trans x] y:[_trans y] z:[_trans z] w:1];
		return self;
	}
	return nil;
}

- (id) initWithRotationY:(float)y
{
	if ( self = [super init] )
	{
		float cosR = cos( y );
		float sinR = sin( y );
	
		cols[0] = [[SBVector4D vector4DWithValuesX: cosR y: 0.f z:-sinR w:0.f] retain];
		cols[1] = [[SBVector4D vector4DWithValuesX: 0.f  y: 1.f z: 0.f  w:0.f] retain];
		cols[2] = [[SBVector4D vector4DWithValuesX: sinR y: 0.f z: cosR w:0.f] retain];
		cols[3] = [[SBVector4D vector4DWithValuesX: 0.f  y: 0.f z: 0.f  w:1.f] retain];
		return self;
	}
	return nil;
}

- (id)copyWithZone:(NSZone *)zone
{
    return [[[SBMat4 allocWithZone: zone] initWithMat4:self] autorelease];
}


- (SBMat4 *)multiplyByMat4:(SBMat4 *)rhs
{
	return [[[SBMat4 alloc] initWithVec4Col0:[self multiplyByVector4D:[rhs col0]]
										col1:[self multiplyByVector4D:[rhs col1]]
										col2:[self multiplyByVector4D:[rhs col2]]
										col3:[self multiplyByVector4D:[rhs col3]]] autorelease];
}

- (SBVector4D *)multiplyByVector4D:(SBVector4D *)rhs
{
	SBVector4D * result = [[[SBVector4D alloc] init] autorelease];

	[result setX: [cols[0] x] * [rhs x] + [cols[1] x] * [rhs y] + [cols[2] x] * [rhs z] + [cols[3] x] * [rhs w]];
	[result setY: [cols[0] y] * [rhs x] + [cols[1] y] * [rhs y] + [cols[2] y] * [rhs z] + [cols[3] y] * [rhs w]];
	[result setZ: [cols[0] z] * [rhs x] + [cols[1] z] * [rhs y] + [cols[2] z] * [rhs z] + [cols[3] z] * [rhs w]];
	[result setW: [cols[0] w] * [rhs x] + [cols[1] w] * [rhs y] + [cols[2] w] * [rhs z] + [cols[3] w] * [rhs w]];
	
	return result;
}

- (void) assign:(SBMat4 *)rhs
{
	[cols[0] assign:[rhs col0]];
	[cols[1] assign:[rhs col1]];
	[cols[2] assign:[rhs col2]];
	[cols[3] assign:[rhs col3]];
}

- (void) setIdentity
{
	[cols[0] setWithValuesX:1 y:0 z:0 w:0];
	[cols[1] setWithValuesX:0 y:1 z:0 w:0];
	[cols[2] setWithValuesX:0 y:0 z:1 w:0];
	[cols[3] setWithValuesX:0 y:0 z:0 w:1];
}

- (void) transpose
{
	SBMat4 * newMat =
		[SBMat4 mat4WithVec4Col0:[SBVector4D vector4DWithValuesX:[cols[0] x] y:[cols[1] x] z:[cols[2] x] w:[cols[3] x]]
							col1:[SBVector4D vector4DWithValuesX:[cols[0] y] y:[cols[1] y] z:[cols[2] y] w:[cols[3] y]] 
							col2:[SBVector4D vector4DWithValuesX:[cols[0] z] y:[cols[1] z] z:[cols[2] z] w:[cols[3] z]]
							col3:[SBVector4D vector4DWithValuesX:[cols[0] w] y:[cols[1] w] z:[cols[2] w] w:[cols[3] w]]];
	[self assign:newMat];
}

- (void) inverse
{
	//NSassert( 0 );
}

- (void) setTranslation:(SBVector3D *)_trans
{
	[cols[3] setX:[_trans x]];
	[cols[3] setY:[_trans y]];
	[cols[3] setZ:[_trans z]];
}

- (SBVector3D *) translation
{
	return [SBVector3D vector3DWithValuesX:[cols[3] x] y:[cols[3] y] z:[cols[3] z]];
}

- (SBVector4D *)col0 { return cols[0]; };
- (SBVector4D *)col1 { return cols[1]; };
- (SBVector4D *)col2 { return cols[2]; };
- (SBVector4D *)col3 { return cols[3]; };

- (SBVector4D *)row0 { return [SBVector4D vector4DWithValuesX:[cols[0] x] y:[cols[1] x] z:[cols[2] x] w:[cols[3] x]]; }
- (SBVector4D *)row1 { return [SBVector4D vector4DWithValuesX:[cols[0] y] y:[cols[1] y] z:[cols[2] y] w:[cols[3] y]]; }
- (SBVector4D *)row2 { return [SBVector4D vector4DWithValuesX:[cols[0] z] y:[cols[1] z] z:[cols[2] z] w:[cols[3] z]]; }
- (SBVector4D *)row3 { return [SBVector4D vector4DWithValuesX:[cols[0] w] y:[cols[1] w] z:[cols[2] w] w:[cols[3] w]]; }

- (void)putContiguousDataInto:(float *)dest
{
	unsigned int i;
	for ( i = 0; i < 4; ++i )
	{
		dest[i*4   ] = [cols[i] x];
		dest[i*4 +1] = [cols[i] y];
		dest[i*4 +2] = [cols[i] z];
		dest[i*4 +3] = [cols[i] w];
	}
}

// Logs the vector Values
- (void)logValues	{	[cols[0] logValues]; [cols[1] logValues]; [cols[2] logValues]; [cols[3] logValues];	}
- (void)logValuesAsRows { [[self row0] logValues]; [[self row1] logValues]; [[self row2] logValues]; [[self row3] logValues]; }

@end
