//
//  SBMaze.h
//  SBGame
//
//  Created by Stuart Bryson on 21/09/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SBCell, SBScene, SBCamera, SBSceneEntity, SBNonuniformSpline;

@interface SBMaze : NSObject {
	NSMutableArray * cells;
	SBCell * startCell, * secondCell, * endCell;
	int size;
}

- (id) initWithSize:(int)_size;
- (void) generateMazeWithCameraSpline:(SBNonuniformSpline *)camSpline;
- (void) debugMaze;

- (void) knockDownWallWithCell:(SBCell *)_currCell neighbour:(SBCell *)_nextCell;
- (NSArray *) getIntactNeighboursOfCell:(SBCell *)_cell;
- (SBCell *) getCellAtX:(int)_x y:(int)_y;
- (NSArray *)cells;

- (void) addMazeToScene:(SBScene *)_scene;
- (void) setWallDoneWithCell:(SBCell *)currCell wall:(int)dir;
- (void) setCameraToStartPosition:(SBCamera *)camera;

@end
