//
//  SBNonuniformSpline.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SBVector3D, SBMat4;

@interface SBSplineData : NSObject
{
	SBVector3D * position;
	SBVector3D * velocity;
	float distance;
}

- (void)setPosition:(SBVector3D *)newPosition;
- (void)setVelocity:(SBVector3D *)newVelocity;
- (void)setDistance:(float)newDistance;

- (SBVector3D *)position;
- (SBVector3D *)velocity;
- (float) distance;

@end

@interface SBNonuniformSpline : NSObject
{
	NSMutableArray * nodes;
	float maxDistance;
}

- (id) initWithNodes:(NSArray *)nodes;

- (int)numNodes;

- (void) addNode:(SBVector3D *)pos;
- (void) buildSpline;
- (SBVector3D *) getPositionAtTime:(float)time;

- (SBVector3D *) getStartVelocity:(int)index;
- (SBVector3D *) getEndVelocity:(int)index;

@end
