//
//  SBOctreeNode.h
//  SBGame
//
//  Created by Stuart Bryson on 25/09/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class AABB, SBSceneEntity;

@interface SBOctreeNode : NSObject {
	int depth;
	
	SBOctreeNode * parent;
	NSMutableArray * children; // 8 children nodes
	
	// store the extents of this node in an AABB object
	AABB * extents;
	
	// list of SBSceneEntity nodes this octree contains
	NSMutableArray * objects;
	
	// neighbours?
}

+ (int)maxDepth;
+ (void)setMaxDepth:(int)_maxDepth;

- (id)initWithParent:(SBOctreeNode *)_parent extents:(AABB *)_extents depth:(int)_depth;

- (BOOL)addObject:(SBSceneEntity *)entity bestFit:(BOOL)bestFit;
- (void)removeObject:(SBSceneEntity *)entity;

- (SBSceneEntity *)collideWith:(AABB *)aabb;

- (int) depth;
- (SBOctreeNode *) parent;
- (NSMutableArray *) children;
- (AABB *) extents;
- (NSMutableArray *) objects;

- (void) logValues;

@end
