//
//  SBOscillatorController.m
//  SBGame
//
//  Created by Stuart Bryson on 20/10/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "SBOscillatorController.h"
#import "SBVector3D.h"
#import "SBMat4.h"
#import "SBSceneEntity.h"


@implementation SBOscillatorController

- (void) initWithSceneEntity:(SBSceneEntity *)entity
					   speed:(SBVector3D *)_speed
				   amplitude:(SBVector3D *)_amplitude
{
	[self setControlledSceneEntity:entity];
	
	speed = [[_speed copy] retain];
	amplitude = [[_amplitude copy] retain];
	oscillation = [[SBVector3D alloc] init];
}

- (void) dealloc
{
	[speed release];
	[amplitude release];
	[originalLocalM release];
	[super dealloc];
}

- (void) setControlledSceneEntity: (SBSceneEntity *)entity
{
	controlled = entity;
	
	if ( originalLocalM )
	{
		[originalLocalM release];
	}
	originalLocalM = [[entity localTransform] copy];
}

- (void) controlWithTime:(float)time
{
	[oscillation assign: [oscillation addVector:[speed multiplyByFloat:time/1000.f]]];
	
//	Vec3 Rot;
//	
//	Rot.x = Tcos(m_Oscillation.x) * m_Amplitude.x;
//	Rot.y = Tcos(m_Oscillation.y) * m_Amplitude.y;
//	Rot.z = Tcos(m_Oscillation.z) * m_Amplitude.z;

	SBMat4 * oscMat = [[SBMat4 alloc] initWithRotationY: cos([oscillation y]) * [amplitude y]];
	[controlled setLocalTransform:[originalLocalM multiplyByMat4:oscMat]];
	
	// This should be done once a frame so we should remove it from here soon
	[controlled updateWorldTransform];
}

@end
