//
//  SBPathPoint.h
//  SBGame
//
//  Created by Stuart Bryson on 24/10/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SBVector3D;

@interface SBPathPoint : NSObject {
	
	SBVector3D * translation;
	
	SBPathPoint * parent; // used for the A* search routine
	
	NSMutableArray * neighbours; // used to find connected neighbours
	
	float f, g, h; // store f = g + h to save computation
	
}

- (id)initWithPathPoint:(SBPathPoint *)rhs;

- (void)setTranslation:(SBVector3D *)newTrans;
- (SBVector3D *)translation;

- (void)setParent:(SBPathPoint *)_parent;
- (SBPathPoint *)parent;

- (void)setG:(float)_g;
- (void)setH:(float)_h;

- (float)g;
- (float)h;
- (float)f;

- (void)addNeighbour:(SBPathPoint *)neighbour;

- (NSArray *)neighbours;

@end
