//
//  SBPathPoint.m
//  SBGame
//
//  Created by Stuart Bryson on 24/10/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "SBPathPoint.h"

#import "SBVector3D.h"

@implementation SBPathPoint

- (id) copyWithZone:(NSZone *)zone
{
    return [[[SBPathPoint allocWithZone:zone] initWithPathPoint:self] autorelease];
}

- (id)init
{
	if ( self = [super init] )
	{
		neighbours = [[NSMutableArray alloc] init];
		translation = [[SBVector3D alloc] init];
		parent = nil;
		g = h = 0;
		return self;
	}
	return nil;
}

- (id)initWithPathPoint:(SBPathPoint *)rhs
{
	if ( self = [super init] )
	{
		neighbours = [[NSMutableArray alloc] initWithArray:[rhs neighbours] copyItems:NO];
		translation = [[[rhs translation] copy] retain];
		g = [rhs g];
		h = [rhs h];
		parent = [rhs parent];
		return self;
	}
	return nil;
}

- (void)dealloc
{
	[neighbours release];
	[translation release];
	[super dealloc];
}

- (void)addNeighbour:(SBPathPoint *)neighbour
{
	[neighbours addObject:neighbour];
}

- (void)setTranslation:(SBVector3D *)newTrans
{
	[translation assign:newTrans];
}
- (SBVector3D *)translation { return translation; }

- (void)setParent:(SBPathPoint *)_parent
{
	parent = _parent;
}
- (SBPathPoint *)parent { return parent; }

- (void)setG:(float)_g
{
	g = _g;
}
- (float)g { return g; }

- (void)setH:(float)_h
{
	h = _h;
}
- (float)h { return h; }

- (float)f { return g + h; }

- (NSArray *)neighbours { return neighbours; }

@end
