//
//  SBPathPoints.h
//  SBGame
//
//  Created by Stuart Bryson on 24/10/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SBPathPoint, SBVector3D;

@interface SBPathPoints : NSObject
{
	NSMutableArray * points; // the array of all path finding points
}

- (id) initWithCells:(NSArray *)cells; // init with an array of SBCells - generate path points from maze

- (SBPathPoint *)getBestCostNodeFrom:(NSArray *)nodes;
- (BOOL)betterNode:(SBPathPoint *)node inList:(NSArray *)list;
- (NSArray *)generatePathFromDestinationNode:(SBPathPoint *)dest;
- (SBPathPoint *)findFarthestFrom:(SBVector3D *)offPath;
- (SBPathPoint *)findClosestTo:(SBVector3D *)offPath;
- (NSArray *)findPathFromVector:(SBVector3D *)from toVector:(SBVector3D *)to;
- (NSArray *)findPathFromPathPoint:(SBPathPoint *)fromPoint toPathPoint:(SBPathPoint *)toPoint;

- (NSArray *)points;
- (void) debugPoints;
@end
