//
//  SBPlyLoader.m
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#include "rply.h"

#import "SBStream.h"
#import "SBDrawable.h"
#import "SBPlyLoader.h"
#import "SBSceneEntity.h"
#import "SBScene.h"

static SBVertexStream * vertexStream;
static float * vertData;
static int vertIdx;

static NSMutableArray * indexArray;
static unsigned short vertA;

static int vertex_cb( p_ply_argument argument )
{
   	vertData[vertIdx] = ply_get_argument_value( argument );
	vertIdx++;
	return 1;
}

static int face_cb( p_ply_argument argument )
{
	long length, value_index;
	ply_get_argument_property( argument, NULL, &length, &value_index );
	
	unsigned short currIdx = (unsigned short)ply_get_argument_value( argument );
	
	if ( value_index == 0 )
	{
		vertA = currIdx; // store this as the anchor point of our flower triangulation
		[indexArray addObject:[NSNumber numberWithUnsignedShort:currIdx]];
	}
	else if ( value_index == 1 || value_index == 2)
	{
		[indexArray addObject:[NSNumber numberWithUnsignedShort:currIdx]];
	}
	else if ( value_index > 2 )
	{
		// get the second vert index which is the last idx in our array
		NSNumber * vertB = [indexArray lastObject];
		
		// add vertA
		[indexArray addObject:[NSNumber numberWithUnsignedShort:vertA]];
			   
		// add vertB
		[indexArray addObject:vertB];

		// add vertC - which is our new vert
		[indexArray addObject:[NSNumber numberWithUnsignedShort:currIdx]];
	}
	
	return 1;
}

@implementation SBPlyLoader

- (BOOL)loadSceneWithPath:(NSString *)scenePath intoScene:(SBScene *)scene
{
	long nvertices;
	p_ply ply = ply_open([scenePath cString], NULL);
	if ( !ply )
	{
		return NO;
	}
	
	if ( !ply_read_header( ply ) )
	{
		return NO;
	}
	
	// vertices
	nvertices = ply_set_read_cb( ply, "vertex", "x", vertex_cb, NULL, 0 );
	ply_set_read_cb( ply, "vertex", "y", vertex_cb, NULL, 0 );
	ply_set_read_cb( ply, "vertex", "z", vertex_cb, NULL, 1 );
	vertexStream = [[SBVertexStream alloc] initWithNumElements:nvertices stride:3 streamType:SI_Position];
	vertData = (float *)[vertexStream data]; // need to cast as compiler resolves the data message to the wrong class
	vertIdx = 0;
	
	// faces
	ply_set_read_cb( ply, "face", "vertex_indices", face_cb, NULL, 0 );
	// need to add to an array rather than straight to the index stream as
	//   we don't know how big the stream is going to be yet
	indexArray = [[NSMutableArray alloc] init];

	NSLog( @"Reading ply file: %s", [scenePath cString] );
	if ( !ply_read( ply ) )
	{
		return NO;
	}
		
	ply_close( ply );
	
	NSLog( @"Number of vertices in stream: %d Number of vertices in ply file: %d. Index: %d",
		   [vertexStream numElements], nvertices, vertIdx );
	if ( nvertices != [vertexStream numElements] )
	{
		NSLog( @"Number of verts don't match" );
		[vertexStream release];
		[indexArray release];
		return NO;
	}
	
	// create our index stream using our indexArray, swapping the winding order as we go
	SBIndexStream * indexStream = [[SBIndexStream alloc] initWithNumElements:[indexArray count]];
	unsigned short * currIdx = [indexStream data];
	for ( int i = 0; i < [indexArray count]; i+=3 )
	{
		currIdx[i] = [[indexArray objectAtIndex:i] unsignedShortValue];
		currIdx[i+1] = [[indexArray objectAtIndex:i+2] unsignedShortValue];
		currIdx[i+2] = [[indexArray objectAtIndex:i+1] unsignedShortValue];
	}
	
	NSEnumerator * en = [indexArray objectEnumerator];
	NSNumber * num;
	while( num = [en nextObject] )
	{
		*currIdx = [num unsignedShortValue];
		currIdx++;
	}

	// create our drawable, scene entity and add to the scene
	SBDrawable * d = [[SBDrawable alloc] init];
	
	[d addStream:vertexStream];
	[d setIndexStream:indexStream];
	
	SBSceneEntity * entity = [[SBSceneEntity alloc] init];
	[entity addDrawable:d];
	[scene addSceneEntity:entity];
	[entity release];
	
	[d release];
	
	[vertexStream debug:@"Ply VertexStream"];
	[indexStream debug:@"Ply IndexStream"];
		
	[vertexStream release];
	[indexStream release];
	
	NSLog( @"Done loading ply file" );
	
	return YES;
}

@end