//
//  SBSceneEntity.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SBDrawable, SBMat4, AABB, SBOctreeNode, SBOscillatorController;

@interface SBSceneEntity : NSObject {
	// drawables
	NSMutableArray * drawables;
	BOOL useAlternateTexture;
	
	//children entities
	NSMutableArray * children;
	SBSceneEntity * parent;
	
	// matrix, bounding box, etc
	SBMat4 * localM, * worldM;
	
	// local bounding box and transformed bounding box which is updated every time the scene entity is transformed
	AABB * localAABB, * worldAABB;
	
	// octree node that contains us, this is a duplex connection useful for optimised updating of
	//  - only particular entities in the octree rather than all entities
	SBOctreeNode * octNode;
	
	// entity name
	NSString * name;
	
	// is the object collidable ( ie, walls vs game elements such as powerups and ghosts )
	BOOL collidable;
}

- (id)initWithSceneEntity:(SBSceneEntity *)_sceneEntity;

- (void) addDrawable: (SBDrawable *) newDrawable;
- (void) setUseAlternateTexture:(BOOL)_alt;
- (BOOL) useAlternateTexture;
- (void) addChild: (SBSceneEntity *) newChild;
- (void) setParent: (SBSceneEntity *) newParent;

- (void) setLocalTransform: (SBMat4 *)_m;
- (void) setLocalAABB: (AABB *) newAABB;
- (void) setOctNode:(SBOctreeNode *)_octNode;
- (void) clearOctNodes; // recursively sets the octNode to nil

- (void) updateWithTime:(float)time;
- (void) updateWorldTransform;
- (void) calculateWorldAABB;
- (void) calculateAABBFromChildren:(AABB *)aabb;

- (void) setName: (NSString *) newName;

- (void) setCollidable:(BOOL)_collidable;
- (BOOL) collidable;

- (BOOL) recursiveRemoveEntity:(SBSceneEntity *)_entity;

- (NSArray *) drawables;
- (NSArray *) children;
- (SBSceneEntity *) parent;
- (SBMat4 *) localTransform;
- (SBMat4 *) worldTransform;
- (AABB *) worldAABB;
- (AABB *) localAABB;
- (SBOctreeNode *) octNode;
- (NSString *) name;

- (SBSceneEntity *) getSceneEntityWithName:(NSString *)entityName;

- (void) logValues;

@end
