//
//  SBStream.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Cocoa/Cocoa.h>

// our stream types
//  - may want to change this in the future
//  - this was all I could think of
typedef enum _SBStreamId {
    SI_Position = 0,
	SI_Normal,
	SI_Tangent,
	SI_Binormal,
	SI_UV0,
	SI_UV1,
	SI_UV2,
	SI_UV3,
	
	SI_Last
	
} SBStreamId;


// our vertex stream object
//  - vertex streams can be of any the stream types above
@interface SBVertexStream : NSObject
{
	SBStreamId streamType;
	unsigned int numElements;
	// stride indicates how many floats we need for each vertex
	//  - eg 2 for UV, 3 for vertex, 3 for normal
	unsigned short stride;
	float * data; // the actual stream data
}

- (id) initWithNumElements:(unsigned int)newNumElements
					stride:(unsigned int)newStride
				streamType:(SBStreamId)newStreamType;

- (void) allocData;
- (void) setNumElements:(unsigned int)newNumElements;
- (void) setStride:(unsigned int)newStride;
- (void) setStreamType:(SBStreamId)newStreamType;

- (void) debug:(NSString *)description;

// getters
- (unsigned int) stride;
- (SBStreamId) streamType;
- (unsigned int) numElements;
- (float *) data;

@end

// our index stream object
@interface SBIndexStream : NSObject
{
	unsigned int numElements;
	unsigned short * data;
}

- (id) initWithNumElements:(unsigned int)newNumElements;

- (void) debug:(NSString *)description;

// getters
- (unsigned short *) data;
- (unsigned int) numElements;

@end