//
//  SBStream.m
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import "SBStream.h"


@implementation SBVertexStream

- (id) init
{
	if ( self = [super init] )
	{
		data = nil;
		return self;
	}
	return nil;
}

- (id) initWithNumElements:(unsigned int)newNumElements
					  stride:(unsigned int)newStride
				  streamType:(SBStreamId)newStreamType
{
	if ( self = [super init] )
	{
		numElements = newNumElements;
		stride = newStride;
		streamType = newStreamType;
		
		data = malloc( numElements * stride * sizeof( float ) );
		return self;
	}
	return nil;
}

// this method should be called when the stream stride and num elements has been set however
//   the data has not been allocated yet
- (void) allocData
{
	data = malloc( numElements * stride * sizeof( float ) );
}

- (void) dealloc
{
	if( data )
	{
		free( data );
	}
	
	data = NULL;
	
	[super dealloc]; // not needed as this class does not inherit but removes compiler warning
}

- (void) setNumElements:(unsigned int)newNumElements
{
	numElements = newNumElements;
}

- (void) setStride:(unsigned int)newStride
{
	stride = newStride; // this is dangerous to set if the data has already been alloced
}

- (void) setStreamType:(SBStreamId)newStreamType
{
	streamType = newStreamType;
}

- (void) debug:(NSString *)description
{
	NSLog( [NSString stringWithFormat:@"SBVertexStream %@ - stride:%d streamType:%d",
			description, stride, streamType] );
	
	unsigned int i, j;
	for ( i = 0; i < numElements; ++i )
	{
		NSMutableString * element = [NSMutableString stringWithString:@"Element: "];
		for ( j = 0; j < stride; ++j )
		{
			[element appendString:[NSString stringWithFormat:@"%f, ", data[i*stride+j]]];
		}
		NSLog( element );
	}
	NSLog( @"\n\n" );
}


- (unsigned int) stride { return stride; }
- (SBStreamId) streamType { return streamType; }
- (unsigned int) numElements { return numElements; }
- (float *) data { return data; }

@end

@implementation SBIndexStream

- (id) initWithNumElements:(unsigned int)newNumElements
{
	if ( self = [super init] )
	{
		numElements = newNumElements;	
		data = malloc( numElements * sizeof( unsigned short ) );
		return self;
	}
	return nil;
}

- (void) dealloc
{
	if( data )
	{
		free( data );
	}
	
	data = NULL;
	
	[super dealloc]; // not needed as this class does not inherit but removes compiler warning
}

- (void) debug:(NSString *)description
{
	NSLog( [NSString stringWithFormat:@"SBIndexStream: %@", description] );
	
	unsigned int i;
	NSMutableString * indicies = [NSMutableString stringWithString:@"Indicies: "];
	for ( i = 0; i < numElements; ++i )
	{
		if ( (i+1) % 3 == 0 )
		{
			[indicies appendFormat:@"%d,  ", data[i]];
		}
		else
		{
			[indicies appendFormat:@"%d ", data[i]];	
		}
	}
	NSLog( indicies );
	NSLog( @"\n\n" );
}

- (unsigned short *) data { return data; }
- (unsigned int) numElements { return numElements; }

@end
