//
//  SBVector3D.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Foundation/Foundation.h>

// This class is used for both points and directions which are mathematically quite similar. Also this cuts down on repeated code
@interface SBVector3D : NSObject {
	// Basic components of a vector
	float x, y, z;
}

// Class methods
+ (SBVector3D *)vector3DWithValuesX:(float)newX y:(float)newY z:(float)newZ;
+ (SBVector3D *)vector3DWithArray:(NSArray *)array;
+ (SBVector3D *)minVector;
+ (SBVector3D *)maxVector;

// Initialisation with values for the components
- (id)initWithValuesX:(float)newX y:(float)newY z:(float)newZ;
// Initialisation with another vector
- (id)initWithVector3D:(SBVector3D *)newVector;
- (id)initWithArray:(NSArray *)array;
- (id)initWithMax;
- (id)initWithMin;

// Assignment method
- (void)assign:(SBVector3D *)rhs;
// Returns an array of NSNumbers
- (NSArray *)asArray;

// Setter with values
- (void)setWithValuesX:(float)newX y:(float)newY z:(float)newZ;
// Set individual components
- (void)setX:(float)newX;
- (void)setY:(float)newY;
- (void)setZ:(float)newZ;

- (void)setMin;
- (void)setMax;

// Get individual components
- (float)x;
- (float)y;
- (float)z;

// Normalise the current vector
- (void)normalise;

// Used mainly for directional vectors, returns the vector of unit length
- (SBVector3D *)unit;

// The length of the vector
- (float)length;

// Mathematical constructs for vector manipulation
- (float)distanceTo:(SBVector3D *)rhs;
- (SBVector3D *)addVector:(SBVector3D *)rhs;
- (SBVector3D *)subtractVector:(SBVector3D *)rhs;
- (SBVector3D *)multiplyByFloat:(float)rhs;
- (SBVector3D *)multiplyByVector:(SBVector3D *)rhs;
- (SBVector3D *)divideByFloat:(float)rhs;
- (SBVector3D *)divideByVector:(SBVector3D *)rhs;

- (BOOL)isZero;
- (BOOL)isMax;
- (BOOL)isMin;
- (BOOL)equals:(SBVector3D *)rhs;
- (float)dotProduct:(SBVector3D *)rhs;
- (SBVector3D *)crossProduct:(SBVector3D *)rhs;

// Debugging
- (void)logValues;

@end
