//
//  SBVector4D.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SBMat4, SBVector3D;

@interface SBVector4D : NSObject
{
	float v[4];
}

+ (SBVector4D *)vector4DWithValuesX:(float)newX y:(float)newY z:(float)newZ w:(float)newW;
+ (SBVector4D *)vector4DWithVector3D:(SBVector3D *)vec3D;

- (id) initWithValuesX:(float)newX y:(float)newY z:(float)newZ w:(float)newW;
- (id) initWithVector4D:(SBVector4D *)newVector4D;
- (id) initWithVector3D:(SBVector3D *)vec3D;

- (void) assign:(SBVector4D *)rhs;

- (void)setWithValuesX:(float)newX y:(float)newY z:(float)newZ; // w = 1
- (void)setWithValuesX:(float)newX y:(float)newY z:(float)newZ w:(float)newW;

- (void)setX:(float)newX;
- (void)setY:(float)newY;
- (void)setZ:(float)newZ;
- (void)setW:(float)newW;

- (void)setZero;
- (void)abs; // abs of each element x = abs(x);
- (float)length; // return ((float)Tsqrt(x*x + y*y + z*z + w*w));
- (float)length3; // ignores w - return ((float)Tsqrt(x*x + y*y + z*z));

- (SBVector4D *)multiplyByVector4D:(SBVector4D *)rhs;
- (SBVector4D *)transform:(SBMat4 *)_trans;

// getters
- (float)x;
- (float)y;
- (float)z;
- (float)w;

// Debugging
- (void)logValues;

@end