//
//  SBVector4D.m
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import "SBVector3D.h"
#import "SBVector4D.h"
#import "SBMat4.h"

@implementation SBVector4D

+ (SBVector4D *)vector4DWithValuesX:(float)newX y:(float)newY z:(float)newZ w:(float)newW
{
	return [[[self alloc] initWithValuesX:newX y:newY z:newZ w:newW] autorelease];
}

+ (SBVector4D *)vector4DWithVector3D:(SBVector3D *)vec3D
{
	return [[[self alloc] initWithVector3D:vec3D] autorelease];
}

- (id) copyWithZone:(NSZone *)zone
{
    return [[[SBVector4D allocWithZone:zone] initWithVector4D:self] autorelease];
}

- (id) initWithValuesX:(float)newX y:(float)newY z:(float)newZ w:(float)newW
{
	if ( self = [super init] )
	{
		v[0] = newX; v[1] = newY; v[2] = newZ; v[3] = newW;
		return self;
	}
	return nil;
}

- (id) initWithVector4D:(SBVector4D *)newVector4D
{
	if ( self = [super init] )
	{
		v[0] = [newVector4D x];
		v[1] = [newVector4D y];
		v[2] = [newVector4D z];
		v[3] = [newVector4D w];
		return self;
	}
	return nil;
}

// assume w = 1.f
- (id) initWithVector3D:(SBVector3D *)vec3D
{
	if ( self = [super init] )
	{
		v[0] = [vec3D x];
		v[1] = [vec3D y];
		v[2] = [vec3D z];
		v[3] = 1.f;
		return self;
	}
	return nil;
}

- (void)assign:(SBVector4D *)rhs
{
	v[0] = [rhs x]; v[1] = [rhs y]; v[2] = [rhs z]; v[3] = [rhs w];
}

- (void)setWithValuesX:(float)newX y:(float)newY z:(float)newZ // w = 1
{
	v[0] = newX; v[1] = newY; v[2] = newZ; v[3] = 1.f;
}

- (void)setWithValuesX:(float)newX y:(float)newY z:(float)newZ w:(float)newW
{
	v[0] = newX; v[1] = newY; v[2] = newZ; v[3] = newW;
}

- (void)setX:(float)newX
{
	v[0] = newX;
}

- (void)setY:(float)newY
{
	v[1] = newY;
}

- (void)setZ:(float)newZ
{
	v[2] = newZ;
}

- (void)setW:(float)newW
{
	v[3] = newW;
}

- (void)setZero
{
	v[0] = v[1] = v[2] = v[3] = 0;
}

- (void)abs // abs of each element
{
	v[0] = abs( v[0] ); v[1] = abs( v[1] ); v[2] = abs( v[2] ); v[3] = abs( v[3] );
}

- (float)length
{
	return (float)sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2] + v[3]*v[3]);
}

- (float)length3 // ignores w
{
	return (float)sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]);
}

// Subtract another vector from the vector
- (SBVector4D *)subtractVector:(SBVector4D *)rhs
{
	return [SBVector4D vector4DWithValuesX:(v[0] - [rhs x]) y:(v[1] - [rhs y]) z:(v[2] - [rhs z]) w:(v[3] - [rhs w])];
}

- (SBVector4D *)multiplyByVector4D:(SBVector4D *)rhs
{
	return [SBVector4D vector4DWithValuesX:(v[0] * [rhs x]) y:(v[1] * [rhs y]) z:(v[2] * [rhs z]) w:(v[3] * [rhs w])];
}

- (SBVector4D *)transform:(SBMat4 *)m
{
	SBVector4D * c0 = [m col0];
	SBVector4D * c1 = [m col1];
	SBVector4D * c2 = [m col2];
	SBVector4D * c3 = [m col3];
	
	return [SBVector4D vector4DWithValuesX:v[0] * [c0 x] + v[1] * [c1 x] + v[2] * [c2 x] + v[3] * [c3 x]
										 y:v[0] * [c0 y] + v[1] * [c1 y] + v[2] * [c2 y] + v[3] * [c3 y]
										 z:v[0] * [c0 z] + v[1] * [c1 z] + v[2] * [c2 z] + v[3] * [c3 z]
										 w:v[0] * [c0 w] + v[1] * [c1 w] + v[2] * [c2 w] + v[3] * [c3 w]];
}

- (float)x { return v[0]; }
- (float)y { return v[1]; }
- (float)z { return v[2]; }
- (float)w { return v[3]; }

// Logs the vector Values
- (void)logValues	{	NSLog(@"X = %f, Y = %f, Z = %f, W = %f", v[0], v[1], v[2], v[3]);	}

@end
