//
//  RGBVector.h
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Cocoa/Cocoa.h>


@interface SBVectorRGB : NSObject
{
	// The components of the colour
	float colour[4];
}

// Class methods for allocating, basically syntactical sugar, the same thing can be achieved by calling alloc and then initWithValues. See notes
+ (SBVectorRGB *)vectorRGBWithVectorRGB:(SBVectorRGB *)rhs;
+ (SBVectorRGB *)vectorRGBWithValue:(float)newValue;
+ (SBVectorRGB *)vectorRGBWithValuesRed:(float)newRed green:(float)newGreen blue:(float)newBlue;

// Initiallise with separate values
- (id)initWithVectorRGB:(SBVectorRGB *)rhs;
- (id)initWithValue:(float)newValue;
- (id)initWithValuesRed:(float)newRed green:(float)newGreen blue:(float)newBlue;

// Assignment method
- (void)assign:(SBVectorRGB *)rhs;

// Setters...
- (void)setWithValuesRed:(float)newRed green:(float)newGreen blue:(float)newBlue;
- (void)setWithValuesNSColor:(NSColor *)newColour;
- (void)setRed:(float)newRed;
- (void)setGreen:(float)newGreen;
- (void)setBlue:(float)newBlue;

// Getters...
- (float)red;
- (float)green;
- (float)blue;
- (float)alpha;
- (float *)asFloat4;


// Makes sure all colour channels are 0 <= x <= 1
- (void)clamp;

// Mathematical manipulation of colours
- (SBVectorRGB *)multiplyByFloat:(float)rhs;
- (SBVectorRGB *)multiplyByColour:(SBVectorRGB *)rhs;
- (SBVectorRGB *)addColour:(SBVectorRGB *)rhs;
- (SBVectorRGB *)averageColour:(SBVectorRGB *)rhs;
- (SBVectorRGB *)attenuateColour:(SBVectorRGB *)rhs depth:(int)depth;
- (BOOL)toleranceCompare:(SBVectorRGB *)rhs tolerance:(float)tolerance;

// Debugging
- (void)logValues;

@end
