//
//  SBVectorRGB.m
//  SBGame
//
//  Created by Stuart Bryson on August 2005.
//  Copyright 2005 Stuart Bryson. All rights reserved.
//

#import "SBVectorRGB.h"


@implementation SBVectorRGB

+ (SBVectorRGB *)vectorRGBWithVectorRGB:(SBVectorRGB *)rhs
{
	return [[[self alloc] initWithVectorRGB:rhs] autorelease];
}

+ (SBVectorRGB *)vectorRGBWithValue:(float)newValue
{
	return [[[self alloc] initWithValuesRed:newValue green:newValue blue:newValue] autorelease];
}

+ (SBVectorRGB *)vectorRGBWithValuesRed:(float)newRed green:(float)newGreen blue:(float)newBlue
{
	return [[[self alloc] initWithValuesRed:newRed green:newGreen blue:newBlue] autorelease];
}

// Initiallise with the same value for each channel
- (id)initWithValue:(float)newValue
{
	return [self initWithValuesRed:newValue green:newValue blue:newValue];
}

// Initiallise with separate values
- (id)initWithValuesRed:(float)newRed green:(float)newGreen blue:(float)newBlue
{
	//initialize the object using the super class's method
	if (self = [super init])
	{	// super init worked.
		colour[0] = newRed;
		colour[1] = newGreen;
		colour[2] = newBlue;
		colour[3] = 1;
		return self;
	}
	return nil;	// Something went wrong
}

// Initialise with another RGBVector.
- (id)initWithVectorRGB:(SBVectorRGB *)rhs
{
	//initialize the object using the super class's method
	if (self = [super init])
	{	// super init worked.
		colour[0] = [rhs red];
		colour[1] = [rhs green];
		colour[2] = [rhs blue];
		colour[3] = 1;
		return self;
	}
	return nil;	// Something went wrong
}

// Assignment method
- (void)assign:(SBVectorRGB *)rhs
{
	colour[0] = [rhs red];
	colour[1] = [rhs green];
	colour[2] = [rhs blue];
}

// Setters...
- (void)setWithValuesRed:(float)newRed green:(float)newGreen blue:(float)newBlue
{
	colour[0] = newRed;
	colour[1] = newGreen;
	colour[2] = newBlue;
}

- (void)setWithValuesNSColor:(NSColor *)newColour
{
	[newColour getRed:&colour[0] green:&colour[1] blue:&colour[2] alpha:&colour[3]];
}

- (void)setRed:(float)newRed		{	colour[0] = newRed;		}
- (void)setGreen:(float)newGreen	{	colour[1] = newGreen;	}
- (void)setBlue:(float)newBlue		{	colour[2] = newBlue;	}
- (void)setAlpha:(float)newAlpha	{	colour[3] = newAlpha;	}

// Getters...
- (float)red						{	return colour[0];	}
- (float)green						{	return colour[1];	}
- (float)blue						{	return colour[2];	}
- (float)alpha						{	return colour[3];	}
- (float *)asFloat4					{	return colour;		}

// Makes sure all colour channels are 0 <= x <= 1
- (void)clamp
{
	colour[0] = colour[0] > 1 ? 1 : colour[0] < 1 ? 0 : colour[0];
	colour[1] = colour[1] > 1 ? 1 : colour[1] < 1 ? 0 : colour[1];
	colour[2] = colour[2] > 1 ? 1 : colour[2] < 1 ? 0 : colour[2];
	colour[3] = colour[3] > 1 ? 1 : colour[3] < 1 ? 0 : colour[3];
}

// Mathematical manipulation of colours - don't use alpha here
- (SBVectorRGB *)multiplyByFloat:(float)rhs
{
	return [SBVectorRGB vectorRGBWithValuesRed:(colour[0] * rhs)
										 green:(colour[1] * rhs)
										  blue:(colour[2] * rhs)];
}

- (SBVectorRGB *)multiplyByColour:(SBVectorRGB *)rhs
{
	return [SBVectorRGB vectorRGBWithValuesRed:(colour[0] * [rhs red])
										 green:(colour[1] * [rhs green])
										  blue:(colour[2] * [rhs blue])];
}

- (SBVectorRGB *)addColour:(SBVectorRGB *)rhs
{
	return [SBVectorRGB vectorRGBWithValuesRed:(colour[0] + [rhs red])
										 green:(colour[1] + [rhs green])
										  blue:(colour[2] + [rhs blue])];
}

- (SBVectorRGB *)averageColour:(SBVectorRGB *)rhs
{
	return [SBVectorRGB vectorRGBWithValuesRed:((colour[0] + [rhs red])/2)
										 green:((colour[1] + [rhs green])/2)
										  blue:((colour[2] + [rhs blue])/2)];
}

- (SBVectorRGB *)attenuateColour:(SBVectorRGB *)rhs depth:(int)depth
{
	return [SBVectorRGB vectorRGBWithValuesRed:((colour[0] + [rhs red])/depth)
										 green:((colour[1] + [rhs green])/depth)
										  blue:((colour[2] + [rhs blue])/depth)];
}

// Returns YES if any absolute colour difference is greater than the tolerance
- (BOOL)toleranceCompare:(SBVectorRGB *)rhs tolerance:(float)tolerance
{
	return ( fabs([rhs red] - colour[0]) > tolerance ||
			 fabs([rhs green] - colour[1]) > tolerance ||
			 fabs([rhs blue] - colour[2]) > tolerance);
}

// Debugging
- (void)logValues
{
	NSLog(@"Red: %f, Green: %f, Blue: %f, Alpha: %f", colour[0], colour[1], colour[2], colour[3]);
}
@end
