//
//  Camera.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Sat Aug 11 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Vector3D.h"


@interface Camera : NSObject {
	Vector3D *location, *lookAt;
	float d, twist;
}
// Class methods
+ (Camera *)cameraWithDictionary:(NSDictionary *)dictionary;

// For making movies
+ (Camera *)cameraWithLinearFrameStart:(Camera *)start end:(Camera *)end currentFrame:(int)currentFrame totalFrames:(int)totalFrames;
+ (Camera *)cameraWithBezierFrames:(NSArray *)controlPoints currentFrame:(int)currentFrame totalFrames:(int)totalFrames;

// Initialisation. Hopefully we never call this first one, it is too long and ugly
- (id)initWithValuesA:(float)newA b:(float)newB c:(float)newC d:(float)newD e:(float)newE f:(float)newF g:(float)newG twist:(float)newTwist;
- (id)initWithVectorsLocation:(Vector3D *)newLocation d:(float)newD lookAt:(Vector3D *)newLookAt twist:(float)newTwist;
- (id)initWithDictionary:(NSDictionary *)dictionary;

- (NSDictionary *)asDictionary;

// Assignment method
- (void)assign:(Camera *)rhs;

// Setters
- (void)setWithValuesA:(float)newA b:(float)newB c:(float)newC d:(float)newD e:(float)newE f:(float)newF g:(float)newG twist:(float)newTwist;
- (void)setWithVectorsLocation:(Vector3D *)newLocation d:(float)newD lookAt:(Vector3D *)newLookAt twist:(float)newTwist;

- (void)setLocation:(Vector3D *)newLocation;
- (void)setLookAt:(Vector3D *)newLookAt;
- (void)setD:(float)newD;
- (void)setTwist:(float)newTwist;

// Getters, some are here for ease of use purposes, renderScene uses them
- (Vector3D *)location;
- (Vector3D *)lookAt;
- (float)a;
- (float)b;
- (float)c;
- (float)d;
- (float)e;
- (float)f;
- (float)g;
- (float)twist;
- (NSString *)name;

@end
