//
//  Checkerboard.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Sep 28 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Material.h"
#import "Vector3D.h"

@interface Checkerboard : Material {
	Material *primary, *secondary;
	Vector3D *size;
}

// Class methods
+ (Checkerboard *)checkerboardWithDictionary:(NSDictionary *)dictionary;

// Getters
- (Material *)primary;
- (Material *)secondary;
- (Vector3D *)size;

// Setters
- (void)setPrimary:(Material *)newMaterial;
- (void)setSecondary:(Material *)newMaterial;
- (void)setSize:(Vector3D *)newSize;

// Which check does this hitpoint lie in, from Hill (2000)
- (Material *)whichCheck:(Vector3D *)hitPoint;

@end
