//
//  Controller.h
//  Controller
//
//  Created by Stuart Bryson and Tim Keighley on Fri Aug 03 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//


#import <Cocoa/Cocoa.h>
#import "World.h"
#import "Preferences.h"

@interface Controller : NSObject
{    
	//Triangle Palette Outlets
	IBOutlet id trianglePalette, triangleName, triangleVertexMatrix, triangleMaterial;
	Triangle *currentTriangle;
	//Sphere Palette Outlets
	IBOutlet id spherePalette, sphereName, sphereCentreMatrix, sphereRadius, sphereSweep, sphereTransformationMatrix, sphereMaterial;
	Sphere *currentSphere;
	//Plane Palette Outlets
	IBOutlet id planePalette, planeName, planePointMatrix, planeNormalMatrix, planeMaterial;
	Plane *currentPlane;
	// Generic Box Palette Outlets
	IBOutlet id genericBoxPalette, genericBoxName, genericBoxVertexAMatrix, genericBoxVertexBMatrix, genericBoxMaterial;
	GenericBox *currentGenericBox;
	// Generic Sphere Palette Outlets
	IBOutlet id genericSpherePalette, genericSphereName, genericSphereMaterial;
	GenericSphere *currentGenericSphere;
	// Generic Torus Palette Outlets
	IBOutlet id genericTorusPalette, genericTorusName, genericTorusMajorRadius, genericTorusMinorRadius, genericTorusMaterial;
	GenericTorus *currentGenericTorus;
	// Generic Tapered Cylinder Palette Outlets
	IBOutlet id genericTaperedCylinderPalette, genericTaperedCylinderName, genericTaperedCylinderCapRadius, genericTaperedCylinderMaterial;
	GenericTaperedCylinder *currentGenericTaperedCylinder;
	// Material Palette Outlets
	IBOutlet id materialPalette, materialName, materialColour, materialReflectionMatrix;
	Material *currentMaterial;
	//Camera Palette Outlets
	IBOutlet id cameraPalette, cameraName, cameraLocationMatrix, cameraLookAtMatrix, cameraD, cameraTwist;
	Camera *currentCamera;	// But wait, there is only one camera. Who can understand the mysteries that are Stuart's mind on too little sleep? Not me.
	//Light Palette Outlets
	IBOutlet id lightPalette, lightName, lightLocationMatrix, lightIntensity, lightCastsShadow, lightColour;
	Light *currentLight;
	//Main Window Outlets
    IBOutlet id mainWindow, rayImageViewer, renderSheet, renderProgress, renderTxtProgress, renderStylePopup, bRun, txtStatusBar;
	
	//Preferences Outlets
	IBOutlet id pTxtWidth, pSliderWidth;
	IBOutlet id pTxtHeight, pSliderHeight;
	IBOutlet id pTxtBlockSize, pSliderBlockSize;
	IBOutlet id pTxtRecursion, pSliderRecursion;
	IBOutlet id pPrefsWindow, pParallel, pPerspective, pLiveUpdate, pAntiAlias;
	
	//Editor Outlets
	IBOutlet id object3DDrawer, object3DView;
	
	//Menu Outlets
	IBOutlet id mEditScene, mOpenScene, mCloseScene, mRun;
	
	//Image and Bitmap Variables
	unsigned char *bitmapData;
	NSRect viewRect;
	NSImage *theImage;
	NSBitmapImageRep *theBitmapRep;
	double color[3], intPart;
	int intColor[3], pixelsHigh, pixelsWide;
	
	BOOL sceneLoaded;
	NSMutableString *sceneName;
	
	//Major Objects
	World *theWorld;
	NSMutableArray *worldObjects;
	Preferences *loadedPreferences;
	
	id objBeingEdited;
}

- (IBAction)renderImage:(id)sender;
- (IBAction)saveImage:(id)sender;

- (IBAction)preferences:(id)sender;
- (IBAction)savePreferences:(id)sender;
- (IBAction)cancelPreferences:(id)sender;

- (IBAction)setRenderStyle:(id)sender;

- (IBAction)updateHeightControls:(id)sender;
- (IBAction)updatePreviewBlockControls:(id)sender;
- (IBAction)updateWidthControls:(id)sender;

- (IBAction)importMaterialLibrary:(id)sender;
- (IBAction)editScene:(id)sender;
- (IBAction)openScene:(id)sender;
- (IBAction)closeScene:(id)sender;
- (IBAction)saveScene:(id)sender;
- (IBAction)saveSceneAs:(id)sender;
- (IBAction)newScene:(id)sender;
- (BOOL)actuallyCloseScene;

- (IBAction)setObjectBeingEdited:(id)sender;
- (IBAction)editObject:(id)sender;
- (IBAction)deleteObject:(id)sender;
- (IBAction)editMaterial:(id)sender;

- (IBAction)quit:(id)sender;

- (void)initBitmapData;
- (void)drawImage;
- (int)renderStyle;
- (IBAction)renderMovie:(id)sender;

- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item;
- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item;
- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item;
- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item;
- (BOOL)outlineView:(NSOutlineView *)outlineView shouldEditTableColumn:(NSTableColumn *)tableColumn item:(id)item;

- (IBAction)refreshSphere:(id)sender;
- (IBAction)refreshPlane:(id)sender;
- (IBAction)refreshCamera:(id)sender;
- (IBAction)refreshLight:(id)sender;
- (IBAction)refreshTriangle:(id)sender;
- (IBAction)refreshGenericBox:(id)sender;
- (IBAction)refreshGenericSphere:(id)sender;
- (IBAction)refreshGenericTorus:(id)sender;
- (IBAction)refreshGenericTaperedCylinder:(id)sender;
- (IBAction)refreshMaterial:(id)sender;

- (IBAction)saveSphere:(id)sender;
- (IBAction)savePlane:(id)sender;
- (IBAction)saveCamera:(id)sender;
- (IBAction)saveLight:(id)sender;
- (IBAction)saveTriangle:(id)sender;
- (IBAction)saveGenericBox:(id)sender;
- (IBAction)saveGenericSphere:(id)sender;
- (IBAction)saveGenericTorus:(id)sender;
- (IBAction)saveGenericTaperedCylinder:(id)sender;
- (IBAction)saveMaterial:(id)sender;

- (IBAction)newSphere:(id)sender;
- (IBAction)newPlane:(id)sender;
- (IBAction)newLight:(id)sender;
- (IBAction)newTriangle:(id)sender;
- (IBAction)newGenericBox:(id)sender;
- (IBAction)newGenericSphere:(id)sender;
- (IBAction)newGenericTorus:(id)sender;
- (IBAction)newGenericTaperedCylinder:(id)sender;

@end
