//
//  GenericBox.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Thu Sep 20 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GenericObject.h"
#import "Vector3D.h"


// This is an axis aligned box
@interface GenericBox : GenericObject {
	// The vertices define diagonally opposite points on the axis-aligned box
	Vector3D *vertexA, *vertexB;
	// This is set to whichever face the ray hits, used when calculating the normal
	int faceHit;
}

// Class methods
+ (GenericBox *)genericBoxWithDictionary:(NSDictionary *)dictionary;

// Getters
- (Vector3D *)vertexA;
- (Vector3D *)vertexB;

// Setters
- (void)setVertexA:(Vector3D *)newVertex;
- (void)setVertexB:(Vector3D *)newVertex;

// This does the actual intersection with the box, after intersect has transformed the ray
- (BOOL)hitBox:(Ray *)ray;

//Debugging
- (void)logValues;

@end
