//
//  GenericObject.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Thu Sep 20 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Object3D.h"
#import "AllTransformations.h"

@interface GenericObject : Object3D {
	// We need to store this for when we write the scene out to a file, and also useful if our Object GUI eventually wants to support generic objects
	NSMutableArray *transformations;
	// We calculate and store this as it is much faster than calculating it every time a ray passes through us
	Transformation *invTransformation;
}

// Getters
- (NSMutableArray *)transformations;
- (Transformation *)transformationAtIndex:(int)index;
- (Transformation *)invTransformation;

// Setters
// This sets the whole transformation matrix, basically just here for completeness, not sure we will ever use this
- (void)setTransformations:(NSArray *)newTransformations;

// Transformation array manipulation routines
// This is used when you want to add a transformation to the transformation array
- (void)addTransformation:(Transformation *)newTransformation atIndex:(unsigned)index;
- (void)deleteTransformationAtIndex:(unsigned)index;

- (void)calculateInvTransformation;

// This is called when we want to intersect a ray with an object
- (Ray *)transformRay:(Ray *)ray;

//Debugging
- (void)logValues;

@end
