//
//  GenericTaperedCylinder.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Tue Oct 24 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GenericObject.h"

// Surface constants
#define WALL 1
#define BASE 2
#define CAP 3

// Should put in Object3D and use wherever necessary
#define SQR(x) ((x)*(x))

@interface GenericTaperedCylinder : GenericObject {
	// The tapered cylinder in Hill (2000) assumes a base radius of 1 at z = 0, and a cap radius of s at z = 1
	float capRadius;
	Vector3D *normal;
	// Which surface did the ray hit
	int surface;
}
// Class methods
+ (GenericTaperedCylinder *)genericTaperedCylinderWithDictionary:(NSDictionary *)dictionary;

// Getters
- (float)capRadius;

// Setters
- (void)setCapRadius:(float)newCapRadius;

@end
