//
//  GenericTorus.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Tue Oct 09 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GenericObject.h"

@interface GenericTorus : GenericObject {
	// These are the major and minor radii respectively. I really should change them name of these to reflect that
	float a, b;
	Vector3D *normal;
}
// Class methods
+ (GenericTorus *)genericTorusWithDictionary:(NSDictionary *)dictionary;

// Getters
- (float)major;
- (float)minor;

// Setters
- (void)setMajor:(float)newMajor;
- (void)setMinor:(float)newMinor;

// We could not get roots.c to compile correctly, so we put them straight in here
int SolveQuadric(double c[], double s[]);
int SolveCubic(double c[], double s[]);
int SolveQuartic(double c[], double s[]);

@end
