//
//  Light.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Tue Aug 14 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Vector3D.h"
#import "RGBVector.h"

@interface Light : NSObject {
	Vector3D *location;
	RGBVector *colour;
	NSMutableString *name;
	float intensity;
	BOOL castsShadow;
}

// Class methods
+ (Light *)lightWithDictionary:(NSDictionary *)dictionary;
+ (Light *)lightWithLinearFrameStart:(Light *)start end:(Light *)end currentFrame:(int)currentFrame totalFrames:(int)totalFrames;
// Initialisation
// Is anyone crazy enough to actually use this ridiculous init routine? Why do you think we are now using dictionaries? Now that we know how to use them, of course
- (id)initWithValuesX:(float)newX y:(float)newY z:(float)newZ red:(float)newRed green:(float)newGreen blue:(float)newBlue intensity:(float)newIntensity
			castsShadow:(BOOL)newCastsShadow name:(NSString *)newName;
- (id)initWithVectorsLocation:(Vector3D *)newLocation colour:(RGBVector *)newColour intensity:(float)newIntensity castsShadow:(BOOL)newCastsShadow
			name:(NSString *)newName;
- (id)initWithDictionary:(NSDictionary *)dictionary;
- (NSDictionary *)asDictionary;

// Getters
- (Vector3D *)location;
- (RGBVector *)colour;
- (NSString *)name;
- (float)intensity;
- (BOOL)castsShadow;

// Setters
- (void)setLocationWithVector:(Vector3D *)newLocation;
- (void)setLocationWithValuesX:(float)newX y:(float)newY z:(float)newZ;
- (void)setColourWithVector:(RGBVector *)newColour;
- (void)setColourWithValuesRed:(float)newRed green:(float)newGreen blue:(float)newBlue;
- (void)setName:(NSString *)newName;
- (void)setCastsShadow:(BOOL)rhs;
- (void)setIntensity:(float)newIntensity;

// Returns a colour which is defined by colour * intensity. Long description for short method
- (RGBVector *)colourWithIntensity;

// Debugging
- (void)logValues;
@end
