//
//  LinearNoiseSource.m
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Oct 26 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import "LinearNoiseSource.h"


@implementation LinearNoiseSource

- (float)scalarNoise:(Vector3D *)point
{
	int i, j, k;
	int ix = FLOOR([point x]), iy = FLOOR([point y]), iz = FLOOR([point z]);
	float fx = [point x] - ix, fy = [point y] - iy, fz = [point z] - iz;
	float d[2][2][2];
	float x0, x1, x2, x3, y0, y1, z0;

	for (k = 0; k <=1; k++)
		for (j = 0; j <= 1; j++)
			for (i = 0; i <=1; i++)
				d[k][j][i] = [self valueLatticeX:(ix + i) y:(iy + j) z:(iz + k)];
	
	// Interpolate in the x direction
	x0 = LERP(fx, d[0][0][0], d[0][0][1]);
	x1 = LERP(fx, d[0][1][0], d[0][1][1]);
	x2 = LERP(fx, d[1][0][0], d[1][0][1]);
	x3 = LERP(fx, d[1][1][0], d[1][1][1]);
	
	// Interpolate in the y direction
	y0 = LERP(fy, x0, x1);
	y1 = LERP(fy, x2, x3);
	
	// Interpolate in the z direction
	z0 = LERP(fz, y0, y1);

//	NSLog (@"z0 in LinearNoiseSource::scalerNoise: %+1.4f", z0);

	return z0;
}

@end
