//
//  Marble.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Oct 26 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Material.h"
#import "LinearNoiseSource.h"
#import "Vector3D.h"
#import "RGBVector.h"

@interface Marble : Material {
	LinearNoiseSource *noise;
	// The amount of turbulence
	float ta;

	// The colour ramp;
//	NSString *filename;
//	NSBitmapImageRep *ramp;

	// The colour ramp is now defined as two RGBVectors, this could easily be changed
	RGBVector *lower, *higher;
}
// Class methods
+ (Marble *)marbleWithDictionary:(NSDictionary *)dictionary;

// Getters
- (RGBVector *)lower;
- (RGBVector *)higher;
- (float)ta;
- (LinearNoiseSource *)noise;

// Setters
- (void)setLower:(RGBVector *)newLower;
- (void)setHigher:(RGBVector *)newHigher;
- (void)setTa:(float)newTa;
- (void)setNoise:(LinearNoiseSource *)newNoise;

@end
