//
//  Marble.m
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Oct 26 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import "Marble.h"


@implementation Marble


// Class methods
+ (Marble *)marbleWithDictionary:(NSDictionary *)dictionary
{	return [[[Marble alloc] initWithDictionary:dictionary] autorelease];		}

// Normal constructor, probably never called, but what the hey
- (id)init
{
	//initialize the object using the super class's method
	if (self = [super init])
	{	// super init worked.
		lower = [[RGBVector alloc] init];
		higher = [[RGBVector alloc] init];
		noise = [[LinearNoiseSource alloc] init];
		return self;
	}
	return nil; // something went wrong.
}

// Used when we are loading a scene file
- (id)initWithDictionary:(NSDictionary *)dictionary
{
	//initialize the object using the super class's method
	if (self = [super initWithDictionary:dictionary])
	{	// super init worked.
		lower = [[RGBVector alloc] initWithArray:[dictionary valueForKey:@"Lower Colour"]];
		higher = [[RGBVector alloc] initWithArray:[dictionary valueForKey:@"Higher Colour"]];
		noise = [[LinearNoiseSource alloc] initWithDictionary:[dictionary valueForKey:@"Noise Source"]];
		ta = [[dictionary valueForKey:@"Turbulance"] floatValue];
		NSLog (@"Turbulance = %1.4f", ta);
		return self;
	}
	return nil; // something went wrong.
}

- (id)copyWithZone:(NSZone *)zone	{	return [[Marble allocWithZone:zone] initWithDictionary:[self asDictionary]];	}

// Destructor
- (void)dealloc
{
	[lower release];
	[higher release];
	[noise release];
	//use the super class's method for instance destruction
	[super dealloc];
}

// Used when we are saving to a scene file
- (NSMutableDictionary *)asDictionary
{
	NSMutableDictionary *dictionary = [super asDictionary];
	[dictionary setObject:[lower asArray] forKey:@"Lower Colour"];
	[dictionary setObject:[higher asArray] forKey:@"Higher Colour"];
	[dictionary setObject:[noise asDictionary] forKey:@"Noise Source"];
	[dictionary setObject:[NSNumber numberWithFloat:ta] forKey:@"Turbulance"];
	[dictionary setObject:@"Marble" forKey:@"Material Type"];
	return dictionary;
}

- (RGBVector *)diffuseColour:(Vector3D *)hitPoint
{
	float y = [hitPoint y] + ta * [noise fractalSum:hitPoint];
	float V = (1.0 + sin(y)) / 2.0;

//	NSLog(@"hitPoint y: %1.4f, y: %1.4f, V: %1.4f, ta: %1.4f", [hitPoint y], y, V, ta);
//	NSLog(@"y:%1.4f, V:%1.4f", y, V);
	
	// Somehow pull the V'th colour out of the bitmapRep, but not tonight
	return [RGBVector rgbVectorInRamp:lower end:higher position:V];
	return nil;
}


// Getters
- (RGBVector *)lower			{	return lower;	}
- (RGBVector *)higher			{	return higher;	}
- (float)ta						{	return ta;		}
- (LinearNoiseSource *)noise	{	return noise;	}

// Setters
- (void)setLower:(RGBVector *)newLower				{	[lower assign:newLower];	}
- (void)setHigher:(RGBVector *)newHigher			{	[higher assign:newHigher];	}
- (void)setTa:(float)newTa							{	ta = newTa;					}
// This is not correct, as noise should use assign, but I haven't written it yet
- (void)setNoise:(LinearNoiseSource *)newNoise		{	noise = newNoise;			}

@end
