//
//  NoiseSource.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Oct 19 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Vector3D.h"

#define kTableSize 256
#define PERM(x)				[self perm:(x)&kTableMask]
#define INDEX(ix,iy,iz)		PERM((ix) + PERM((iy) + PERM(iz)))
#define FLOOR(x)			((int)(x) - ((x) < 0 && (x) != (int)(x)))
#define LERP(x,a,b)			(a) + ((b) - (a)) * (x)

@interface NoiseSource : NSObject {
	int numOctaves;
	float lacunarity;
	float gain;

	int kTableMask;
	// Now doing this as a method
//	unsigned char perm[kTableSize];
	float valueTable[kTableSize];
	NSMutableArray *vectorTable;
}

// Used when we are loading a scene file
- (id)initWithDictionary:(NSDictionary *)dictionary;
// Used when we are saving to a scene file
- (NSMutableDictionary *)asDictionary;

// Getters
- (int)numOctaves;
- (float)lacunarity;
- (float)gain;
- (unsigned char)perm:(int)x;

// Setters
- (void)setNumOctaves:(int)octaves;
- (void)setLacunarity:(float)newLacunarity;
- (void)setGain:(float)newGain;

- (void)valueTableInit:(int)seed;
- (void)vectorTableInit:(int)seed;

- (float)valueLatticeX:(int)ix y:(int)iy z:(int)iz;
- (Vector3D *)vectorLatticeX:(int)ix y:(int)iy z:(int)iz;

- (float)scalarNoise:(Vector3D *)point;
- (Vector3D *)vectorNoise:(Vector3D *)point;

- (float)scalarTurbulence:(Vector3D *)point;
- (Vector3D *)vectorTurbulence:(Vector3D *)point;

- (float)fractalSum:(Vector3D *)p;
- (Vector3D *)vFractalSum:(Vector3D *)point;

- (float)fBm:(Vector3D *)point;
- (Vector3D *)vfBm:(Vector3D *)point;

- (void)logValues;

@end
