//
//  Pitch.m
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Mon Oct 08 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import "Pitch.h"

@implementation Pitch

- (id)initWithDictionary:(NSDictionary *)dictionary
{
	if (self = [super initWithDictionary:dictionary])	//initialize the object using the super class's method
	{	// super init worked.
		angle = [[dictionary valueForKey:@"Angle"] floatValue];
			
		transformation[0][0] = 1;
		transformation[0][1] = transformation[0][2] = transformation[0][3] = 0;

		transformation[1][0] = 0;
		transformation[1][1] = cos(angle);
		transformation[1][2] = -sin(angle);
		transformation[1][3] = 0;
	
		transformation[2][0] = 0;
		transformation[2][1] = sin(angle);
		transformation[2][2] = cos(angle);
		transformation[2][3] = 0;
	
		transformation[3][0] = transformation[3][1] = transformation[3][2] = 0;
		transformation[3][3] = 1;
		return self;
	}
	return nil; // something went wrong.
}

// Used when we are saving to a scene file
- (NSMutableDictionary *)asDictionary
{
	NSMutableDictionary *dictionary = [super asDictionary];
	[dictionary setObject:[NSNumber numberWithFloat:angle] forKey:@"Angle"];
	[dictionary setObject:@"Pitch" forKey:@"Transformation Type"];
	return dictionary;
}

// Debugging
- (void)logValues
{
	NSLog(@"Transformation of type: Pitch");
	[super logValues];
}
@end
