//
//  Plane.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Tue Aug 14 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Object3D.h"

@interface Plane : Object3D {
	Vector3D *point, *normal;
}
// Class methods
+ (Plane *)planeWithDictionary:(NSDictionary *)dictionary;

// Initialisation
- (id)initWithVectorsPoint:(Vector3D *)newPoint normal:(Vector3D *)newNormal name:(NSString *)newName;
- (id)initWithDictionary:(NSDictionary *)dictionary;
// Copy Constructor
- (id)copyWithZone:(NSZone *)zone;

// Getters
- (NSDictionary *)asDictionary;
- (Vector3D *)point;
- (Vector3D *)normal;
// Setters
- (void)setPointWithVector:(Vector3D *)newPoint;
- (void)setPointWithValuesX:(float)newX y:(float)newY z:(float)newZ;
- (void)setNormalWithVector:(Vector3D *)newNormal;
- (void)setNormalWithValuesX:(float)newX y:(float)newY z:(float)newZ;

@end
