//
//  Preferences.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Sat Aug 11 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RGBVector.h"

// This is the Carbon way of saving preferences and it does save it in the corrent location in OS X, however we have since found a much simpler way, but haven't implemented it yet, as this is working
@interface Preferences : NSObject {
	CFStringRef appName,
				previewBlockSizeKey,
				pixelsWideKey,
				pixelsHighKey,
				useParallelProjectionKey,
				recursionDepthKey,
				liveUpdateKey,
				antiAliasKey;
	CFNumberRef value;
	int 		highScore,
				previewBlockSize,
				pixelsWide,
				pixelsHigh,
				useParallelProjection,
				recursionDepth,
				liveUpdate,
				antiAlias;
}

// Load and save to disk
- (void)reload;
- (void)save;

// Getters
- (int)previewBlockSize;
- (int)pixelsWide;
- (int)pixelsHigh;
- (int)useParallelProjection;
- (int)recursionDepth;
- (int)liveUpdate;
- (int)antiAlias;

// Setters
- (void)setPreviewBlockSize:(int)newPreviewBlockSize;
- (void)setPixelsWide:(int)newPixelsWide;
- (void)setPixelsHigh:(int)newPixelsHigh;
- (void)setUseParallelProjection:(int)newUseParallelProjection;
- (void)setRecursionDepth:(int)newRecursionDepth;
- (void)setLiveUpdate:(int)newLiveUpdate;
- (void)setAntiAlias:(int)newAntiAlias;

@end
