//
//  Preferences.m
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Sat Aug 11 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import "Preferences.h"
#define PREVIEW_BLOCK_SIZE 0
#define PIXELS_WIDE 1
#define PIXELS_HIGH 2
#define BKG_RED 3
#define BKG_GREEN 4
#define BKG_BLUE 5


@implementation Preferences
- (id) init
{
	if (self = [super init])	//initialize the object using the super class's method
	{	// super init worked.
		appName = CFSTR("RayTracer");
		previewBlockSizeKey = CFSTR("Preview Block Size");
		pixelsWideKey = CFSTR("Image Pixels Wide");
		pixelsHighKey = CFSTR("Image Pixels High");
		useParallelProjectionKey = CFSTR("Parallel Projection");
		recursionDepthKey = CFSTR("Recursion Depth");
		liveUpdateKey = CFSTR("Live Update");
		antiAliasKey = CFSTR("Anti Alias");
		[self reload];
		return self;
	}
	return nil; // something went wrong.
}

- (void)reload
{
	// Load Preview Block Size Prefs
	value = CFPreferencesCopyAppValue(previewBlockSizeKey, appName);   
	if (value)
	{
		if (!CFNumberGetValue(value, kCFNumberIntType, &previewBlockSize))
			previewBlockSize = 5;	//Default Value if loaded value is invalid
		CFRelease(value);
	}
	else 
		previewBlockSize = 5;	//Defula Value if none exists
		
	// Load Pixels Wide Prefs
	value = CFPreferencesCopyAppValue(pixelsWideKey, appName);   
	if (value)
	{
		if (!CFNumberGetValue(value, kCFNumberIntType, &pixelsWide))
			pixelsWide = 640;	//Default Value if loaded value is invalid
		CFRelease(value);
	}
	else 
		pixelsWide = 640;	//Defula Value if none exists
		
	// Load Pixels Wide Prefs
	value = CFPreferencesCopyAppValue(pixelsHighKey, appName);   
	if (value)
	{
		if (!CFNumberGetValue(value, kCFNumberIntType, &pixelsHigh))
			pixelsHigh = 480;	//Default Value if loaded value is invalid
		CFRelease(value);
	}
	else 
		pixelsHigh = 480;
	
	// Load Use Parallel Projection Prefs
	value = CFPreferencesCopyAppValue(useParallelProjectionKey, appName);   
	if (value)
	{
		if (!CFNumberGetValue(value, kCFNumberIntType, &useParallelProjection))
			useParallelProjection = 0;	//Default Value if loaded value is invalid
		CFRelease(value);
	}
	else 
		useParallelProjection = 0;
	
	// Load Recursion Depth Prefs
	value = CFPreferencesCopyAppValue(recursionDepthKey, appName);   
	if (value)
	{
		if (!CFNumberGetValue(value, kCFNumberIntType, &recursionDepth))
			recursionDepth = 1;	//Default Value if loaded value is invalid
		CFRelease(value);
	}
	else 
		recursionDepth = 1;
		
	// Load Live Update Prefs
	value = CFPreferencesCopyAppValue(liveUpdateKey, appName);   
	if (value)
	{
		if (!CFNumberGetValue(value, kCFNumberIntType, &liveUpdate))
			liveUpdate = 0;	//Default Value if loaded value is invalid
		CFRelease(value);
	}
	else 
		liveUpdate = 0;

	// Load Anti Alias Prefs
	value = CFPreferencesCopyAppValue(antiAliasKey, appName);   
	if (value)
	{
		if (!CFNumberGetValue(value, kCFNumberIntType, &antiAlias))
			antiAlias = 0;	//Default Value if loaded value is invalid
		CFRelease(value);
	}
	else 
		antiAlias = 0;
}

// There is a far simpler way of doing this, but this works, so when we have time (laughs) we will implemenent the easier way, ie Cocoa vs Carbon
- (void)save
{
	value = CFNumberCreate(NULL, kCFNumberIntType, &previewBlockSize); 
	CFPreferencesSetAppValue(previewBlockSizeKey, value, appName);
	CFRelease(value);
	value = CFNumberCreate(NULL, kCFNumberIntType, &pixelsWide); 
	CFPreferencesSetAppValue(pixelsWideKey, value, appName);
	CFRelease(value);
	value = CFNumberCreate(NULL, kCFNumberIntType, &pixelsHigh); 
	CFPreferencesSetAppValue(pixelsHighKey, value, appName);
	CFRelease(value);
	value = CFNumberCreate(NULL, kCFNumberIntType, &useParallelProjection); 
	CFPreferencesSetAppValue(useParallelProjectionKey, value, appName);
	CFRelease(value);
	value = CFNumberCreate(NULL, kCFNumberIntType, &recursionDepth); 
	CFPreferencesSetAppValue(recursionDepthKey, value, appName);
	CFRelease(value);
	value = CFNumberCreate(NULL, kCFNumberIntType, &liveUpdate); 
	CFPreferencesSetAppValue(liveUpdateKey, value, appName);
	CFRelease(value);	
	value = CFNumberCreate(NULL, kCFNumberIntType, &antiAlias); 
	CFPreferencesSetAppValue(antiAliasKey, value, appName);
	CFRelease(value);	
	(void)CFPreferencesAppSynchronize(appName);
}


//SHOULD IMPLEMENT SOME ERROR CHECKING HERE
- (int)previewBlockSize			{ return previewBlockSize; }
- (int)pixelsWide				{ return pixelsWide; }
- (int)pixelsHigh				{ return pixelsHigh; }
- (int)useParallelProjection	{ return useParallelProjection; }
- (int)recursionDepth			{ return recursionDepth; }
- (int)liveUpdate				{ return liveUpdate; }
- (int)antiAlias				{ return antiAlias; }

- (void)setPreviewBlockSize:(int)newPreviewBlockSize			{ previewBlockSize = newPreviewBlockSize; }
- (void)setPixelsWide:(int)newPixelsWide						{ pixelsWide = newPixelsWide; }
- (void)setPixelsHigh:(int)newPixelsHigh						{ pixelsHigh = newPixelsHigh; }
- (void)setUseParallelProjection:(int)newUseParallelProjection	{ useParallelProjection = newUseParallelProjection; }
- (void)setRecursionDepth:(int)newRecursionDepth				{ recursionDepth = newRecursionDepth; }
- (void)setLiveUpdate:(int)newLiveUpdate						{ liveUpdate = newLiveUpdate; }
- (void)setAntiAlias:(int)newAntiAlias							{ antiAlias = newAntiAlias; }

@end