//
//  RGBVector.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Sat Aug 11 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Cocoa/Cocoa.h>


@interface RGBVector : NSObject {
	// The components of the colour
	float red, green, blue;
}

// Class methods for allocating, basically syntactical sugar, the same thing can be achieved by calling alloc and then initWithValues. See notes
+ (RGBVector *)rgbVectorWithRGBVector:(RGBVector *)rhs;
+ (RGBVector *)rgbVectorWithValue:(float)newValue;
+ (RGBVector *)rgbVectorWithValuesRed:(float)newRed green:(float)newGreen blue:(float)newBlue;
+ (RGBVector *)rgbVectorWithArray:(NSArray *)array;
+ (RGBVector *)rgbVectorWithLinearFrameStart:(RGBVector *)start end:(RGBVector *)end currentFrame:(int)currentFrame totalFrames:(int)totalFrames;
+ (RGBVector *)rgbVectorInRamp:(RGBVector *)start end:(RGBVector *)end position:(float)position;

// Initiallise with separate values
- (id)initWithValue:(float)newValue;
- (id)initWithValuesRed:(float)newRed green:(float)newGreen blue:(float)newBlue;
- (id)initWithArray:(NSArray *)array;
- (id)initWithRGBVector:(RGBVector *)newRGBVector;
- (NSArray *)asArray;
// Assignment method
- (void)assign:(RGBVector *)rhs;
// Setters...
- (void)setWithValuesRed:(float)newRed green:(float)newGreen blue:(float)newBlue;
- (void)setWithValuesNSColor:(NSColor *)newColour;
- (void)setRed:(float)newRed;
- (void)setGreen:(float)newGreen;
- (void)setBlue:(float)newBlue;
// Getters...
- (float)red;
- (float)green;
- (float)blue;

// Makes sure all colour channels are 0 <= x <= 1
- (void)clamp;
// Mathematical manipulation of colours
- (RGBVector *)multiplyByFloat:(float)rhs;
- (RGBVector *)multiplyByColour:(RGBVector *)rhs;
- (RGBVector *)addColour:(RGBVector *)rhs;
- (RGBVector *)averageColour:(RGBVector *)rhs;
- (RGBVector *)attenuateColour:(RGBVector *)rhs depth:(int)depth;
- (BOOL)toleranceCompare:(RGBVector *)rhs tolerance:(float)tolerance;

// Debugging
- (void)logValues;
@end
