//
//  Ray.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Aug 03 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Vector3D.h"

@interface Ray : NSObject {
	Vector3D *origin, *direction;
	// The distance from the origin to the intersect. T does not make any sense as its own entity in this object, it is only useful for intersection methods
	float t;
}
// Initialise with another ray
- (id)initWithRay:(Ray *)ray;

// Assignment method
- (void)assign:(Ray *)rhs;

// Getters
- (Vector3D *)origin;
- (Vector3D *)direction;
- (float)t;

// Setters
- (void)setOriginWithValuesX:(float)newX y:(float)newY z:(float)newZ;
- (void)setOriginWithVector:(Vector3D *)newOrigin;
- (void)setDirectionWithValuesX:(float)newX y:(float)newY z:(float)newZ;
- (void)setDirectionWithVector:(Vector3D *)newDirection;
- (void)setT:(float)newT;

- (Vector3D *)hitPoint;

@end
