//
//  Ray.m
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Aug 03 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import "Ray.h"


@implementation Ray

// Boring init
- (id)init
{
	//initialize the object using the super class's method
	if (self = [super init])
	{	// super init worked.
		origin = [[Vector3D alloc] initWithValuesX:0 y:0 z:0];
		direction = [[Vector3D alloc] initWithValuesX:1 y:0 z:0];
		t = 0;
		return self;
	}
	return nil; // something went wrong.
}

// Initialise with another ray
- (id)initWithRay:(Ray *)ray
{
	//initialize the object using the super class's method
	if (self = [super init])
	{	// super init worked.
		origin = [[Vector3D alloc] initWithVector:[ray origin]];
		direction = [[Vector3D alloc] initWithVector:[[ray direction] unit]];
		t = [ray t];
		return self;
	}
	return nil; // something went wrong.
}

// Destructor
- (void)dealloc
{
	//release ray origin
	[origin release];
	//release ray direction
	[direction release];
	//use the super class's method for instance destruction
	[super dealloc];
}

// Assignment method
- (void)assign:(Ray *)rhs
{
	[origin assign:[rhs origin]];
	[direction assign:[[rhs direction] unit]];
	t = [rhs t];
}

// Getters
- (Vector3D *)origin	{	return origin;		}
- (Vector3D *)direction	{	return direction;	}
- (float)t				{	return t;			}

// Setters
- (void)setOriginWithValuesX:(float)newX y:(float)newY z:(float)newZ	{	[origin setWithValuesX:newX y:newY z:newZ];		}
- (void)setOriginWithVector:(Vector3D *)newVector						{	[origin assign:newVector];	}

- (void)setDirectionWithValuesX:(float)newX y:(float)newY z:(float)newZ	{	[direction setWithValuesX:newX y:newY z:newZ];	}
- (void)setDirectionWithVector:(Vector3D *)newDirection					{	[direction assign:[newDirection unit]];	}

- (void)setT:(float)newT	{	t = newT;	}

// Calculate hitpoint based on origin, direction and t, which has hopefully been set before calling this function
- (Vector3D *)hitPoint
{
 return [Vector3D vector3DWithValuesX:([origin x] + [direction x] * t)
            y:([origin y] + [direction y] * t)
            z:([origin z] + [direction z] * t)
    ];
}

@end
